/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.mvc.cache;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ClientCacheTemplate {
    private static final Logger logger = LoggerFactory.getLogger(ClientCacheTemplate.class);
    private static final String IF_MODIFIED_SINCE = "If-Modified-Since";
    private static final String LAST_MODIFIED = "Last-Modified";

    public void execute(HttpServletRequest req, HttpServletResponse resp, ClientCacheCallback callback) throws ServletException, IOException {
        long lastModifiedFromServer;
        long lastModifiedFromClient = this.getLastModifiedFromClient(req);
        if (this.ifNotModifiedSince(lastModifiedFromClient, lastModifiedFromServer = this.getLastModifiedFromServer(req))) {
            resp.setStatus(304);
            if (logger.isDebugEnabled()) {
                logger.debug("Not Modified " + req.getRequestURI());
            }
        } else {
            this.setLastModified(req, resp, lastModifiedFromServer);
            callback.doGet(req, resp);
        }
    }

    protected void setLastModified(HttpServletRequest req, HttpServletResponse resp, long lastModified) {
        resp.addDateHeader(LAST_MODIFIED, lastModified);
    }

    protected boolean ifNotModifiedSince(long lastModifiedFromClient, long lastModifiedFromServer) {
        return lastModifiedFromServer > 0L && lastModifiedFromClient > 0L && lastModifiedFromClient / 1000L >= lastModifiedFromServer / 1000L;
    }

    protected long getLastModifiedFromClient(HttpServletRequest req) {
        return req.getDateHeader(IF_MODIFIED_SINCE);
    }

    protected abstract long getLastModifiedFromServer(HttpServletRequest var1);

    @FunctionalInterface
    public static interface ClientCacheCallback {
        public void doGet(HttpServletRequest var1, HttpServletResponse var2) throws ServletException, IOException;
    }
}

