/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.mvc.callback.json;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Writer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.n2oapp.context.StaticSpringContext;
import net.n2oapp.framework.api.JsonUtil;
import net.n2oapp.framework.api.exception.N2oException;
import net.n2oapp.framework.api.ui.AlertMessageBuilder;
import net.n2oapp.framework.api.ui.ResponseMessage;
import net.n2oapp.framework.mvc.callback.ServletCallback;
import net.n2oapp.framework.mvc.exception.ControllerArgumentException;

public abstract class JsonServletCallback
implements ServletCallback {
    protected ObjectMapper objectMapper;
    private AlertMessageBuilder messageBuilder;

    protected JsonServletCallback() {
        this.objectMapper = JsonUtil.getMapper();
        this.messageBuilder = (AlertMessageBuilder)StaticSpringContext.getBean(AlertMessageBuilder.class);
    }

    public JsonServletCallback(ObjectMapper objectMapper, AlertMessageBuilder messageBuilder) {
        this.objectMapper = objectMapper;
        this.messageBuilder = messageBuilder;
    }

    @Override
    public void onService(HttpServletRequest req, HttpServletResponse res) throws ControllerArgumentException, IOException {
        this.getObjectMapper().writeValue((Writer)res.getWriter(), this.resolveSuccessModel(req, res));
    }

    @Override
    public void onError(N2oException e, HttpServletRequest req, HttpServletResponse res) throws IOException {
        if (!res.isCommitted()) {
            res.setStatus(e.getHttpStatus());
            this.getObjectMapper().writeValue((Writer)res.getWriter(), this.resolveFailModel(e, req, res));
        }
    }

    protected void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    private ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    @Override
    public String getContentType() {
        return "application/json";
    }

    protected ResponseMessage createResponseMsg(N2oException e) {
        return this.messageBuilder.build((Exception)e);
    }

    public abstract Object resolveSuccessModel(HttpServletRequest var1, HttpServletResponse var2) throws ControllerArgumentException, IOException;

    public abstract Object resolveFailModel(N2oException var1, HttpServletRequest var2, HttpServletResponse var3);
}

