/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.mvc.callback.jsp;

import java.io.IOException;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.n2oapp.framework.mvc.callback.ServletCallback;

public abstract class AbstractJspServletCallback
implements ServletCallback {
    private ServletContext servletContext;
    private Type type = Type.FORWARD;
    protected String prefix = "/";
    protected String suffix = ".jsp";

    protected AbstractJspServletCallback(ServletContext servletContext, Type type) {
        if (servletContext == null) {
            throw new IllegalArgumentException("servletContext is null");
        }
        this.servletContext = servletContext;
        if (type == null) {
            throw new IllegalArgumentException("type is null");
        }
        this.type = type;
    }

    protected void forward(HttpServletRequest req, HttpServletResponse res, String view, Map<String, Object> model) throws ServletException, IOException {
        RequestDispatcher dispatcher = this.servletContext.getRequestDispatcher(this.getSrcPath(view));
        if (dispatcher == null) {
            throw new IllegalStateException("dispatcher is null");
        }
        this.setAttributes(req, model);
        dispatcher.forward((ServletRequest)req, (ServletResponse)res);
    }

    protected void include(HttpServletRequest req, HttpServletResponse res, String view, Map<String, Object> model) throws ServletException, IOException {
        RequestDispatcher dispatcher = this.servletContext.getRequestDispatcher(this.getSrcPath(view));
        if (dispatcher == null) {
            throw new IllegalStateException("dispatcher is null");
        }
        this.setAttributes(req, model);
        dispatcher.include((ServletRequest)req, (ServletResponse)res);
    }

    protected void setAttributes(HttpServletRequest req, Map<String, Object> model) {
        for (Map.Entry<String, Object> entry : model.entrySet()) {
            req.setAttribute(entry.getKey(), entry.getValue());
        }
    }

    protected String getSrcPath(String view) {
        return this.prefix + view + this.suffix;
    }

    @Override
    public String getContentType() {
        return "text/html";
    }

    public Type getType() {
        return this.type;
    }

    public static enum Type {
        FORWARD,
        INCLUDE;

    }
}

