/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.mvc.callback.jsp;

import java.io.IOException;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.n2oapp.framework.api.exception.N2oException;
import net.n2oapp.framework.mvc.callback.jsp.AbstractJspServletCallback;
import net.n2oapp.framework.mvc.callback.jsp.ModelAndView;
import net.n2oapp.framework.mvc.callback.jsp.ModelAndViewResolver;
import net.n2oapp.framework.mvc.exception.ControllerArgumentException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JspServletCallback
extends AbstractJspServletCallback {
    private static final Logger logger = LoggerFactory.getLogger(JspServletCallback.class);
    private ModelAndView modelAndView;
    private ModelAndViewResolver supplierModelAndView;

    public JspServletCallback(ServletContext servletContext, AbstractJspServletCallback.Type type, String view, Map<String, Object> model) {
        super(servletContext, type);
        this.modelAndView = new ModelAndView(model, view);
    }

    public JspServletCallback(ServletContext servletContext, String view, Map<String, Object> model) {
        this(servletContext, AbstractJspServletCallback.Type.FORWARD, view, model);
    }

    public JspServletCallback(ServletContext servletContext, AbstractJspServletCallback.Type type, ModelAndViewResolver supplierModelAndView) {
        super(servletContext, type);
        this.supplierModelAndView = supplierModelAndView;
    }

    public JspServletCallback(ServletContext servletContext, ModelAndViewResolver supplierModelAndView) {
        this(servletContext, AbstractJspServletCallback.Type.FORWARD, supplierModelAndView);
    }

    @Override
    public String getContentType() {
        return "text/html";
    }

    @Override
    public void onService(HttpServletRequest req, HttpServletResponse res) throws ControllerArgumentException, IOException, ServletException {
        ModelAndView result;
        ModelAndView modelAndView = result = this.modelAndView != null ? this.modelAndView : this.supplierModelAndView.resolve(req);
        if (this.getType().equals((Object)AbstractJspServletCallback.Type.FORWARD)) {
            this.forward(req, res, result.getView(), result.getModel());
        } else {
            this.include(req, res, result.getView(), result.getModel());
        }
    }

    @Override
    public void onError(N2oException e, HttpServletRequest req, HttpServletResponse res) throws IOException {
        logger.error(e.getMessage(), (Throwable)e);
        if (!res.isCommitted()) {
            req.setAttribute("javax.servlet.error.exception", (Object)e);
            res.setContentType("text/html");
            res.sendError(e.getHttpStatus());
        }
    }
}

