/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.ui.servlet.data;

import com.fasterxml.jackson.databind.JavaType;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.n2oapp.criteria.dataset.DataSet;
import net.n2oapp.framework.api.exception.N2oException;
import net.n2oapp.framework.api.rest.GetDataResponse;
import net.n2oapp.framework.api.rest.SetDataResponse;
import net.n2oapp.framework.api.user.UserContext;
import net.n2oapp.framework.mvc.n2o.N2oServlet;
import net.n2oapp.framework.ui.controller.DataController;
import org.apache.commons.io.IOUtils;

public class DataServlet
extends N2oServlet {
    private DataController controller;

    public DataServlet(DataController controller) {
        this.controller = controller;
    }

    public void init() throws ServletException {
        super.init();
    }

    protected void safeDoGet(HttpServletRequest req, HttpServletResponse res) throws IOException {
        GetDataResponse result = this.controller.getData(req.getPathInfo(), req.getParameterMap(), (UserContext)req.getAttribute("user"));
        res.setStatus(result.getStatus());
        res.setContentType("application/json");
        this.objectMapper.writeValue((Writer)res.getWriter(), (Object)result);
    }

    protected void safeDoPost(HttpServletRequest req, HttpServletResponse res) throws IOException {
        SetDataResponse result = this.controller.setData(req.getPathInfo(), req.getParameterMap(), this.getHeaders(req), this.getRequestBody(req), (UserContext)req.getAttribute("user"));
        res.setStatus(result.getStatus());
        res.setContentType("application/json");
        this.objectMapper.writeValue((Writer)res.getWriter(), (Object)result);
    }

    protected void safeDoPut(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.safeDoPost(req, resp);
    }

    protected void safeDoDelete(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.safeDoPost(req, resp);
    }

    private Object getRequestBody(HttpServletRequest request) {
        try {
            if (request.getReader() == null) {
                return new DataSet();
            }
            String body = IOUtils.toString((Reader)request.getReader()).trim();
            if (body.startsWith("[")) {
                return this.objectMapper.readValue(body, (JavaType)this.objectMapper.getTypeFactory().constructCollectionType(List.class, DataSet.class));
            }
            return this.objectMapper.readValue(body, DataSet.class);
        }
        catch (IOException e) {
            throw new N2oException((Throwable)e);
        }
    }

    private Map<String, String[]> getHeaders(HttpServletRequest req) {
        HashMap<String, String[]> result = new HashMap<String, String[]>();
        Enumeration iter = req.getHeaderNames();
        while (iter.hasMoreElements()) {
            String name = (String)iter.nextElement();
            result.put(name, new String[]{req.getHeader(name)});
        }
        return result;
    }
}

