/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.ui.controller.query;

import java.util.Set;
import net.n2oapp.criteria.api.CollectionPage;
import net.n2oapp.criteria.api.Criteria;
import net.n2oapp.criteria.dataset.DataSet;
import net.n2oapp.framework.api.MetadataEnvironment;
import net.n2oapp.framework.api.data.QueryProcessor;
import net.n2oapp.framework.api.exception.N2oException;
import net.n2oapp.framework.api.rest.ControllerType;
import net.n2oapp.framework.api.rest.GetDataResponse;
import net.n2oapp.framework.api.ui.AlertMessageBuilder;
import net.n2oapp.framework.api.ui.QueryRequestInfo;
import net.n2oapp.framework.api.ui.QueryResponseInfo;
import net.n2oapp.framework.api.ui.RequestInfo;
import net.n2oapp.framework.api.util.SubModelsProcessor;
import net.n2oapp.framework.engine.modules.stack.DataProcessingStack;
import net.n2oapp.framework.ui.controller.query.DefaultValuesController;
import org.springframework.stereotype.Controller;

@Controller
public class CopyValuesController
extends DefaultValuesController {
    public CopyValuesController(DataProcessingStack dataProcessingStack, QueryProcessor queryProcessor, SubModelsProcessor subModelsProcessor, AlertMessageBuilder messageBuilder, MetadataEnvironment environment) {
        super(dataProcessingStack, queryProcessor, subModelsProcessor, messageBuilder, environment);
    }

    @Override
    public GetDataResponse execute(QueryRequestInfo requestInfo, QueryResponseInfo responseInfo) {
        DataSet defaultModel = this.extractCopyModel(requestInfo, responseInfo);
        return new GetDataResponse(defaultModel, (Criteria)requestInfo.getCriteria(), responseInfo, requestInfo.getSuccessAlertWidgetId());
    }

    protected DataSet extractCopyModel(QueryRequestInfo requestInfo, QueryResponseInfo responseInfo) {
        DataSet defaultModel = this.extractDefaultModel(requestInfo, responseInfo);
        if (requestInfo.getQuery() != null) {
            try {
                CollectionPage<DataSet> queryDefaultPage = this.executeQuery(requestInfo, responseInfo);
                DataSet queryDefaultModel = (DataSet)queryDefaultPage.getCollection().iterator().next();
                CopyValuesController.merge(defaultModel, queryDefaultModel, requestInfo.getQuery().getCopiedFields());
                return defaultModel;
            }
            catch (N2oException e) {
                responseInfo.addMessage(this.getMessageBuilder().build((Exception)((Object)e), (RequestInfo)requestInfo));
            }
        }
        defaultModel.remove((Object)"id");
        return defaultModel;
    }

    private static void merge(DataSet defaultModel, DataSet queryModel, Set<String> fieldsToCopy) {
        if (fieldsToCopy != null) {
            defaultModel.merge(queryModel);
            defaultModel.entrySet().removeIf(stringObjectEntry -> !fieldsToCopy.contains(stringObjectEntry.getKey()));
        } else {
            defaultModel.clear();
        }
    }

    public ControllerType getControllerType() {
        return ControllerType.copy;
    }
}

