/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.ui.controller.query;

import java.util.Map;
import net.n2oapp.criteria.api.CollectionPage;
import net.n2oapp.criteria.api.Criteria;
import net.n2oapp.criteria.dataset.DataSet;
import net.n2oapp.framework.api.MetadataEnvironment;
import net.n2oapp.framework.api.data.QueryProcessor;
import net.n2oapp.framework.api.exception.N2oException;
import net.n2oapp.framework.api.rest.GetDataResponse;
import net.n2oapp.framework.api.ui.AlertMessageBuilder;
import net.n2oapp.framework.api.ui.QueryRequestInfo;
import net.n2oapp.framework.api.ui.QueryResponseInfo;
import net.n2oapp.framework.api.ui.RequestInfo;
import net.n2oapp.framework.api.util.SubModelsProcessor;
import net.n2oapp.framework.engine.modules.stack.DataProcessingStack;
import net.n2oapp.framework.ui.controller.query.GetController;

public abstract class DefaultValuesController
extends GetController {
    protected DefaultValuesController(DataProcessingStack dataProcessingStack, QueryProcessor queryProcessor, SubModelsProcessor subModelsProcessor, AlertMessageBuilder messageBuilder, MetadataEnvironment environment) {
        super(dataProcessingStack, queryProcessor, subModelsProcessor, messageBuilder, environment);
    }

    @Override
    public GetDataResponse execute(QueryRequestInfo requestInfo, QueryResponseInfo responseInfo) {
        try {
            DataSet defaultModel = this.extractDefaultModel(requestInfo, responseInfo);
            return new GetDataResponse(defaultModel, (Criteria)requestInfo.getCriteria(), responseInfo, requestInfo.getSuccessAlertWidgetId());
        }
        catch (N2oException e) {
            String widgetId = requestInfo.getFailAlertWidgetId() == null ? requestInfo.getMessagesForm() : requestInfo.getFailAlertWidgetId();
            GetDataResponse response = new GetDataResponse(this.getMessageBuilder().buildMessages((Exception)((Object)e), (RequestInfo)requestInfo), widgetId);
            response.setStatus(e.getHttpStatus());
            return response;
        }
    }

    protected DataSet extractDefaultModel(QueryRequestInfo requestInfo, QueryResponseInfo responseInfo) {
        DataSet defaultModel;
        DataSet dataSet = defaultModel = requestInfo.getData() == null ? new DataSet() : new DataSet((Map)requestInfo.getData());
        if (requestInfo.getQuery() != null) {
            this.getSubModelsProcessor().executeSubModels(requestInfo.getQuery().getSubModelQueries(), defaultModel);
            CollectionPage<DataSet> queryDefaultPage = this.executeQuery(requestInfo, responseInfo);
            if (!queryDefaultPage.getCollection().isEmpty()) {
                DataSet queryDefaultModel = (DataSet)queryDefaultPage.getCollection().iterator().next();
                defaultModel.merge(queryDefaultModel, DataSet.EXTEND_IF_VALUE_NOT_NULL);
            }
        }
        return defaultModel;
    }
}

