/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.ui.servlet;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.n2oapp.framework.api.config.AppConfig;
import net.n2oapp.framework.api.context.ContextProcessor;
import net.n2oapp.framework.config.N2oConfigBuilder;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class AppConfigJsonWriter {
    private ObjectMapper objectMapper = new ObjectMapper();
    private PropertyResolver propertyResolver;
    private ContextProcessor contextProcessor;
    private String path = "classpath*:META-INF/config.json";
    private String overridePath = "classpath*:META-INF/config-build.json";
    private List<String> configs = Collections.emptyList();

    public AppConfigJsonWriter() {
    }

    public AppConfigJsonWriter(String path) {
        this();
        this.path = path;
    }

    public N2oConfigBuilder<AppConfig> build() {
        N2oConfigBuilder configBuilder = new N2oConfigBuilder(new AppConfig(), this.objectMapper, this.propertyResolver, this.contextProcessor);
        PathMatchingResourcePatternResolver r = new PathMatchingResourcePatternResolver();
        try {
            for (Resource resource : r.getResources(this.path)) {
                configBuilder.read(resource);
            }
            this.readOverrideResource(r, (N2oConfigBuilder<AppConfig>)configBuilder);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        this.configs.forEach(arg_0 -> ((N2oConfigBuilder)configBuilder).read(arg_0));
        return configBuilder;
    }

    protected void readOverrideResource(PathMatchingResourcePatternResolver r, N2oConfigBuilder<AppConfig> configBuilder) throws IOException {
        for (Resource resource : r.getResources(this.overridePath)) {
            configBuilder.read(resource);
        }
    }

    public void writeValues(PrintWriter out, Map<String, Object> addedValues) {
        this.build().addAll(addedValues).write((Writer)out);
    }

    public Map<String, Object> getValues(Map<String, Object> addedValues) {
        return (Map)this.objectMapper.convertValue((Object)this.build().addAll(addedValues).get(), Map.class);
    }

    public void setPropertyResolver(PropertyResolver propertyResolver) {
        this.propertyResolver = propertyResolver;
    }

    public void setContextProcessor(ContextProcessor contextProcessor) {
        this.contextProcessor = contextProcessor;
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setConfigs(List<String> configs) {
        this.configs = configs;
    }

    public void setOverridePath(String overridePath) {
        this.overridePath = overridePath;
    }
}

