/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.ui.servlet;

import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.n2oapp.framework.api.event.MetadataChangedEvent;
import net.n2oapp.framework.api.event.N2oEventListener;
import net.n2oapp.framework.mvc.cache.ClientCacheTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.cache.support.NoOpCache;

public class ModifiedClientCacheTemplate
extends ClientCacheTemplate
implements N2oEventListener<MetadataChangedEvent> {
    private static final Logger logger = LoggerFactory.getLogger(ModifiedClientCacheTemplate.class);
    private CacheManager cacheManager;
    private String cacheRegion = "n2o.client";

    public ModifiedClientCacheTemplate(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    protected long getLastModifiedFromServer(HttpServletRequest req) {
        Long lastModified = (Long)this.getCache().get((Object)req.getRequestURI(), Long.class);
        return lastModified != null ? lastModified : -1L;
    }

    protected void setLastModified(HttpServletRequest req, HttpServletResponse resp, long lastModified) {
        lastModified = lastModified > 0L ? lastModified : new Date().getTime();
        super.setLastModified(req, resp, lastModified);
        this.getCache().put((Object)req.getRequestURI(), (Object)lastModified);
    }

    protected Cache getCache() {
        Cache cache = this.cacheManager.getCache(this.cacheRegion);
        if (cache == null) {
            logger.warn("Cannot find cache named [" + this.cacheRegion + "] for CacheTemplate");
            return new NoOpCache(this.cacheRegion);
        }
        return cache;
    }

    public void setCacheRegion(String cacheRegion) {
        this.cacheRegion = cacheRegion;
    }

    public void handleEvent(MetadataChangedEvent event) {
        this.getCache().clear();
    }
}

