/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.ui.servlet;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import net.n2oapp.framework.mvc.exception.ControllerArgumentException;

public abstract class ServletUtil {
    public static String normalizePath(HttpServletRequest req) {
        Object path = req.getPathInfo();
        if (path == null) {
            path = req.getRequestURI();
        }
        if (!((String)path).startsWith("/")) {
            path = "/" + (String)path;
        }
        if (((String)path).endsWith("/") && ((String)path).length() > 1) {
            path = ((String)path).substring(0, ((String)path).length() - 1);
        }
        return path;
    }

    public static boolean isAjax(HttpServletRequest servletRequest) {
        String header = servletRequest.getHeader("X-Requested-With");
        return header != null && header.equalsIgnoreCase("XMLHttpRequest");
    }

    public static String getRequestParam(HttpServletRequest request, String paramName) {
        String parameter = request.getParameter(paramName);
        if (parameter != null && !parameter.isEmpty()) {
            return parameter;
        }
        return null;
    }

    public static String getRequestParamRequired(HttpServletRequest request, String paramName) {
        String parameter = request.getParameter(paramName);
        if (parameter != null && !parameter.isEmpty()) {
            return parameter;
        }
        throw new ControllerArgumentException("unknown parameter '" + paramName + "'");
    }

    public static Integer getRequestParamInteger(HttpServletRequest request, String paramName) {
        String parameter = ServletUtil.getRequestParam(request, paramName);
        return parameter != null ? Integer.valueOf(parameter) : null;
    }

    public static int getRequestParamInt(HttpServletRequest request, String paramName) {
        String parameter = ServletUtil.getRequestParam(request, paramName);
        return parameter != null ? Integer.valueOf(parameter) : 0;
    }

    public static Map<String, String> getRequestParamsWithPrefix(HttpServletRequest request, String paramPrefix) {
        LinkedHashMap<String, String> values = new LinkedHashMap<String, String>();
        for (Map.Entry entry : request.getParameterMap().entrySet()) {
            if (!((String)entry.getKey()).startsWith(paramPrefix)) continue;
            String parameter = ((String)entry.getKey()).substring(paramPrefix.length());
            String value = entry.getValue() != null && ((String[])entry.getValue()).length > 0 && ((String[])entry.getValue())[0] != null ? ((String[])entry.getValue())[0] : null;
            values.put(parameter, value);
        }
        return values;
    }
}

