/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.ui.context;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import net.n2oapp.framework.api.context.ContextEngine;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class SessionContextEngine
implements ContextEngine {
    public Object get(String name) {
        HttpSession session = this.getHttpSession();
        if ("sessionId".equals(name)) {
            return session.getId();
        }
        return session.getAttribute(name);
    }

    public void set(Map<String, Object> dataSet) {
        HttpSession httpSession = this.getHttpSession();
        dataSet.forEach((arg_0, arg_1) -> ((HttpSession)httpSession).setAttribute(arg_0, arg_1));
    }

    public Object get(String param, Map<String, Object> baseParams) {
        if (baseParams.containsKey(param)) {
            return baseParams.get(param);
        }
        return this.get(param);
    }

    public void set(Map<String, Object> dataSet, Map<String, Object> baseParams) {
        HashMap<String, Object> result = new HashMap<String, Object>(baseParams);
        result.putAll(dataSet);
        this.set(result);
    }

    private HttpSession getHttpSession() {
        RequestAttributes attrs = RequestContextHolder.getRequestAttributes();
        if (attrs instanceof NativeWebRequest) {
            HttpServletRequest request = (HttpServletRequest)((NativeWebRequest)attrs).getNativeRequest();
            return request.getSession();
        }
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.currentRequestAttributes();
        return requestAttributes.getRequest().getSession();
    }
}

