/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.ui.servlet.data;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import javax.servlet.http.HttpServletRequest;
import net.n2oapp.criteria.api.Direction;
import net.n2oapp.criteria.dataset.DataSet;
import net.n2oapp.framework.api.JsonUtil;
import net.n2oapp.framework.mvc.api.SimpleServletTemplate;
import net.n2oapp.framework.mvc.exception.ControllerArgumentException;
import net.n2oapp.framework.mvc.n2o.N2oServlet;
import net.n2oapp.framework.mvc.util.ServletUtil;
import net.n2oapp.framework.ui.controller.request.GetDataRequest;
import org.apache.commons.io.IOUtils;

public abstract class AbstractDataServlet
extends N2oServlet {
    protected SimpleServletTemplate servletTemplate = new SimpleServletTemplate();

    protected GetDataRequest extractGetDataRequestParameters(HttpServletRequest request) throws ControllerArgumentException {
        GetDataRequest result = new GetDataRequest(request);
        Map parameters = ServletUtil.decodeParameters((HttpServletRequest)request);
        for (Map.Entry entry : parameters.entrySet()) {
            String fieldId;
            if (((String)entry.getKey()).equals("queryId")) {
                result.setQueryId((String)entry.getValue());
                continue;
            }
            if (((String)entry.getKey()).equals("model")) {
                String model = (String)entry.getValue();
                if (model == null) continue;
                result.setModel(model);
                continue;
            }
            if (((String)entry.getKey()).equals("selectedId")) {
                String selectedId = (String)entry.getValue();
                if (selectedId == null) continue;
                result.setSelectedId(selectedId);
                continue;
            }
            if (((String)entry.getKey()).equals("pageId")) {
                result.setPageId((String)entry.getValue());
                continue;
            }
            if (((String)entry.getKey()).equals("containerId")) {
                result.setContainerId((String)entry.getValue());
                continue;
            }
            if (((String)entry.getKey()).equals("page")) {
                result.setPage(Integer.valueOf((String)entry.getValue()));
                continue;
            }
            if (((String)entry.getKey()).equals("size")) {
                result.setSize(Integer.valueOf((String)entry.getValue()));
                continue;
            }
            if (((String)entry.getKey()).equals("count")) {
                result.setCount(Integer.valueOf((String)entry.getValue()));
                continue;
            }
            if (((String)entry.getKey()).equals("contentType")) {
                result.setContentType((String)entry.getValue());
                continue;
            }
            if (((String)entry.getKey()).startsWith("sorting.")) {
                fieldId = ((String)entry.getKey()).substring("sorting.".length());
                Direction direction = Direction.valueOf((String)((String)entry.getValue()));
                result.getSortings().put(fieldId, direction);
                continue;
            }
            if (((String)entry.getKey()).startsWith("filter.")) {
                fieldId = ((String)entry.getKey()).substring("filter.".length());
                result.getFilters().put(fieldId, entry.getValue());
                continue;
            }
            if (((String)entry.getKey()).equals("encoding")) continue;
            if (((String)entry.getKey()).equals("columns")) {
                result.setColumns(Arrays.asList(((String)entry.getValue()).split(",")));
                continue;
            }
            ControllerArgumentException.throwUnknownParameter((String)((String)entry.getKey()));
        }
        if (request.getHeader("query-source") != null) {
            result.setQuerySource(request.getHeader("query-source"));
        }
        if (result.getQueryId() == null) {
            if (result.getPageId() == null) {
                ControllerArgumentException.throwRequiredParameter((String)"pageId");
            }
            if (result.getContainerId() == null) {
                ControllerArgumentException.throwRequiredParameter((String)"containerId");
            }
        }
        result.setUser(this.getUser(request));
        return result;
    }

    protected <T, V> T extractSetDataRequestParameters(HttpServletRequest request, BiFunction<V, Map<String, String>, T> mapper) throws ControllerArgumentException, IOException {
        return mapper.apply(this.readBody(request), ServletUtil.decodeParameters((HttpServletRequest)request));
    }

    protected Object readBody(HttpServletRequest request) throws IOException {
        if (request.getReader() == null) {
            return new DataSet();
        }
        String body = IOUtils.toString((Reader)request.getReader()).trim();
        ObjectMapper objectMapper = JsonUtil.getMapper();
        if (body.startsWith("[")) {
            return objectMapper.readValue(body, (JavaType)objectMapper.getTypeFactory().constructCollectionType(List.class, DataSet.class));
        }
        return objectMapper.readValue(body, DataSet.class);
    }
}

