/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.ui.controller;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import net.n2oapp.criteria.api.Direction;
import net.n2oapp.criteria.api.Sorting;
import net.n2oapp.criteria.dataset.DataSet;
import net.n2oapp.criteria.filters.FilterType;
import net.n2oapp.framework.api.MetadataEnvironment;
import net.n2oapp.framework.api.criteria.N2oPreparedCriteria;
import net.n2oapp.framework.api.criteria.Restriction;
import net.n2oapp.framework.api.metadata.Compiled;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.event.action.UploadType;
import net.n2oapp.framework.api.metadata.global.dao.N2oQuery;
import net.n2oapp.framework.api.metadata.local.CompiledObject;
import net.n2oapp.framework.api.metadata.local.CompiledQuery;
import net.n2oapp.framework.api.metadata.pipeline.ReadCompileBindTerminalPipeline;
import net.n2oapp.framework.api.metadata.pipeline.ReadCompileTerminalPipeline;
import net.n2oapp.framework.api.register.route.MetadataRouter;
import net.n2oapp.framework.api.ui.ActionRequestInfo;
import net.n2oapp.framework.api.ui.QueryRequestInfo;
import net.n2oapp.framework.api.user.UserContext;
import net.n2oapp.framework.config.compile.pipeline.N2oPipelineSupport;
import net.n2oapp.framework.config.metadata.compile.context.ActionContext;
import net.n2oapp.framework.config.metadata.compile.context.QueryContext;
import net.n2oapp.framework.config.register.route.N2oRouter;

public abstract class AbstractController {
    private MetadataRouter router;
    private MetadataEnvironment environment;

    public AbstractController(MetadataEnvironment environment) {
        this.environment = environment;
        this.router = new N2oRouter(environment, (ReadCompileTerminalPipeline)environment.getReadCompilePipelineFunction().apply((Object)new N2oPipelineSupport(environment)));
    }

    public AbstractController(MetadataEnvironment environment, MetadataRouter router) {
        this.environment = environment;
        this.router = router;
    }

    public void setEnvironment(MetadataEnvironment environment) {
        this.environment = environment;
    }

    public void setRouter(MetadataRouter router) {
        this.router = router;
    }

    protected ActionRequestInfo createActionRequestInfo(String path, Map<String, String[]> queryParams, Map<String, String[]> headerParams, Object body, UserContext user) {
        ActionContext actionCtx = (ActionContext)this.router.get(path, CompiledObject.class, queryParams);
        DataSet queryData = actionCtx.getParams(path, queryParams);
        CompiledObject object = (CompiledObject)((ReadCompileBindTerminalPipeline)this.environment.getReadCompileBindTerminalPipelineFunction().apply((Object)new N2oPipelineSupport(this.environment))).get((CompileContext)actionCtx, queryData);
        CompiledObject.Operation operation = (CompiledObject.Operation)object.getOperations().get(actionCtx.getOperationId());
        DataSet bodyData = this.convertToDataSet(body, actionCtx.getOperationMapping());
        this.putParams(headerParams, bodyData, (Map<String, String>)actionCtx.getOperationMapping());
        this.putParams(queryParams, bodyData, (Map<String, String>)actionCtx.getOperationMapping());
        this.putParams(queryData, bodyData, (Map<String, String>)actionCtx.getOperationMapping());
        ActionRequestInfo requestInfo = new ActionRequestInfo();
        requestInfo.setContext((CompileContext)actionCtx);
        requestInfo.setQueryData(queryData);
        requestInfo.setData((Object)bodyData);
        requestInfo.setUser(user);
        requestInfo.setObject(object);
        requestInfo.setOperation(operation);
        requestInfo.setRedirect(actionCtx.getRedirect());
        requestInfo.setMessageOnSuccess(actionCtx.isMessageOnSuccess());
        requestInfo.setMessageOnFail(actionCtx.isMessageOnFail());
        requestInfo.setSuccessAlertWidgetId(actionCtx.getSuccessAlertWidgetId());
        requestInfo.setFailAlertWidgetId(actionCtx.getFailAlertWidgetId());
        requestInfo.setMessagesForm(actionCtx.getMessagesForm());
        return requestInfo;
    }

    private void putParams(Map<String, String[]> params, DataSet data, Map<String, String> mapping) {
        if (params != null && mapping != null) {
            for (Map.Entry<String, String> entry : mapping.entrySet()) {
                String[] value = params.get(entry.getKey());
                if (value == null) continue;
                if (value.length == 1) {
                    data.put(entry.getValue(), (Object)value[0]);
                    continue;
                }
                data.put(entry.getValue(), Arrays.asList(value));
            }
        }
    }

    private void putParams(DataSet params, DataSet data, Map<String, String> mapping) {
        if (params != null && mapping != null) {
            for (Map.Entry<String, String> entry : mapping.entrySet()) {
                Object value = params.get((Object)entry.getKey());
                if (value == null) continue;
                data.put(entry.getValue(), value);
            }
        }
    }

    private DataSet convertToDataSet(Object body, Map<String, String> mapping) {
        DataSet result;
        DataSet dataSet = result = body instanceof DataSet ? (DataSet)body : new DataSet((Map)body);
        if (mapping != null) {
            for (Map.Entry<String, String> entry : mapping.entrySet()) {
                Object value = result.get((Object)entry.getKey());
                if (value == null || result.get((Object)entry.getValue()) != null && !result.containsKey((Object)entry.getKey())) continue;
                result.put(entry.getValue(), value);
            }
        }
        return result;
    }

    private void prepareSelectedId(QueryRequestInfo requestInfo) {
        String selectedId = requestInfo.getData().getString("selectedId");
        if (requestInfo.getQuery() == null) {
            return;
        }
        if (selectedId == null) {
            return;
        }
        N2oQuery.Field fieldPK = (N2oQuery.Field)requestInfo.getQuery().getFieldsMap().get("id");
        String domain = fieldPK != null ? fieldPK.getDomain() : null;
        requestInfo.setSelectedId(this.environment.getDomainProcessor().doDomainConversion(domain, (Object)selectedId));
    }

    private N2oPreparedCriteria prepareCriteria(CompiledQuery query, DataSet data, QueryContext queryCtx) {
        N2oPreparedCriteria criteria = new N2oPreparedCriteria();
        Integer page = data.getInteger("page");
        criteria.setPage(page != null ? page : 1);
        Integer size = data.getInteger("size");
        criteria.setSize(size != null ? size : (queryCtx.getQuerySize() != null ? queryCtx.getQuerySize() : 10));
        Integer count = data.getInteger("count");
        criteria.setCount(count);
        if (query != null) {
            criteria.setSortings(this.getSortings(data, queryCtx.getSortingMap()));
            this.prepareRestrictions(query, criteria, data);
        }
        return criteria;
    }

    private List<Sorting> getSortings(DataSet data, Map<String, String> sortingMap) {
        ArrayList<Sorting> sortings = new ArrayList<Sorting>();
        DataSet sortingsData = data.getDataSet("sorting");
        if (sortingsData == null) {
            return sortings;
        }
        for (String key : sortingsData.flatKeySet()) {
            String fieldId = sortingMap == null || !sortingMap.containsKey(key) ? key : sortingMap.get(key);
            String value = sortingsData.getString(key);
            Direction direction = value != null ? Direction.valueOf((String)value.toUpperCase()) : Direction.ASC;
            sortings.add(new Sorting(fieldId, direction));
        }
        return sortings;
    }

    private void prepareRestrictions(CompiledQuery query, N2oPreparedCriteria criteria, DataSet data) {
        for (Map.Entry paramEntry : query.getParamToFilterIdMap().entrySet()) {
            Object value = data.get(paramEntry.getKey());
            if (value == null) continue;
            String filterId = (String)paramEntry.getValue();
            if (query.getInvertFiltersMap().containsKey(filterId)) {
                Map.Entry typeEntry = (Map.Entry)query.getInvertFiltersMap().get(filterId);
                String fieldId = (String)typeEntry.getKey();
                FilterType filterType = (FilterType)typeEntry.getValue();
                Restriction restriction = new Restriction(fieldId, value, filterType);
                criteria.addRestriction(restriction);
                continue;
            }
            criteria.putAdditionalField(filterId, value);
        }
    }

    @Deprecated
    protected QueryRequestInfo createQueryRequestInfo(HttpServletRequest request) {
        QueryContext queryCtx = (QueryContext)this.getRoutingResult(request, CompiledQuery.class);
        DataSet data = queryCtx.getParams(request.getPathInfo(), request.getParameterMap());
        CompiledQuery query = (CompiledQuery)((ReadCompileBindTerminalPipeline)this.environment.getReadCompileBindTerminalPipelineFunction().apply((Object)new N2oPipelineSupport(this.environment))).get((CompileContext)queryCtx, data);
        QueryRequestInfo requestInfo = new QueryRequestInfo();
        requestInfo.setUser(this.getUser(request));
        requestInfo.setQuery(query);
        requestInfo.setData(data);
        requestInfo.setUpload(queryCtx.getUpload() != null ? queryCtx.getUpload() : UploadType.query);
        requestInfo.setCriteria(this.prepareCriteria(requestInfo.getQuery(), data, queryCtx));
        requestInfo.setSuccessAlertWidgetId(queryCtx.getSuccessAlertWidgetId());
        requestInfo.setFailAlertWidgetId(queryCtx.getFailAlertWidgetId());
        requestInfo.setMessagesForm(queryCtx.getMessagesForm());
        request.setAttribute("messageForm", (Object)queryCtx.getFailAlertWidgetId());
        this.prepareSelectedId(requestInfo);
        return requestInfo;
    }

    protected QueryRequestInfo createQueryRequestInfo(String path, Map<String, String[]> params, UserContext user) {
        QueryContext queryCtx = (QueryContext)this.router.get(path, CompiledQuery.class, params);
        DataSet data = queryCtx.getParams(path, params);
        CompiledQuery query = (CompiledQuery)((ReadCompileBindTerminalPipeline)this.environment.getReadCompileBindTerminalPipelineFunction().apply((Object)new N2oPipelineSupport(this.environment))).get((CompileContext)queryCtx, data);
        QueryRequestInfo requestInfo = new QueryRequestInfo();
        requestInfo.setUser(user);
        requestInfo.setQuery(query);
        requestInfo.setData(data);
        requestInfo.setUpload(queryCtx.getUpload() != null ? queryCtx.getUpload() : UploadType.query);
        requestInfo.setCriteria(this.prepareCriteria(requestInfo.getQuery(), data, queryCtx));
        requestInfo.setSuccessAlertWidgetId(queryCtx.getSuccessAlertWidgetId());
        requestInfo.setFailAlertWidgetId(queryCtx.getFailAlertWidgetId());
        requestInfo.setMessagesForm(queryCtx.getMessagesForm());
        requestInfo.setSize(requestInfo.getCriteria().getSize());
        this.prepareSelectedId(requestInfo);
        return requestInfo;
    }

    private UserContext getUser(HttpServletRequest req) {
        UserContext user = (UserContext)req.getAttribute("user");
        if (user == null) {
            throw new IllegalStateException("User is not initialized");
        }
        return user;
    }

    private <D extends Compiled> CompileContext<D, ?> getRoutingResult(HttpServletRequest req, Class<D> compiledClass) {
        String path = req.getPathInfo();
        return this.router.get(path, compiledClass, req.getParameterMap());
    }
}

