/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.ui.controller;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import net.n2oapp.framework.api.exception.N2oUserException;
import net.n2oapp.framework.api.exception.N2oValidationException;
import net.n2oapp.framework.api.exception.SeverityType;
import net.n2oapp.framework.api.metadata.local.CompiledObject;
import net.n2oapp.framework.api.ui.ResponseMessage;

public class BulkOperationUtils {
    public static final String BULK_MODEL_FIELD = "$bulkModel";
    public static final String MSG = "msg";
    public static final String SEVERITY = "severity";
    private static final String IDS_PREFIX = "_ids_";
    private static final String ABORT = null;
    private static final String IGNORE_ALL = "ignoreAll";
    private static final String IGNORE = "ignore";

    public static void throwExceptionWithChoice(Exception e, Map<String, Boolean> ignoreIds, String id, CompiledObject.Operation operation) {
        String summary = null;
        int httpStatus = 300;
        if (e instanceof N2oValidationException) {
            N2oValidationException n2oException = (N2oValidationException)e;
            summary = n2oException.getMessage();
            httpStatus = n2oException.getHttpStatus();
        }
        String defaultSummary = "net.n2oapp.framework.ui.dialogs.bulk.fail";
        summary = summary != null ? summary : defaultSummary;
        summary = String.format("<div class=\"n2o-dialog-choice__text\">%s</div>", summary);
        N2oUserException n2oException = new N2oUserException(summary);
        n2oException.setSeverity(SeverityType.warning);
        n2oException.setHttpStatus(httpStatus);
        n2oException.setData(Arrays.asList(operation.getName(), id));
        throw n2oException;
    }

    public static Choice deserializeChoice(String choice) {
        Choice res = new Choice();
        if (choice == null || choice.length() < 1) {
            return res;
        }
        String[] s = choice.split(Pattern.quote(IDS_PREFIX));
        switch (s[0]) {
            case "ignoreAll": {
                res.ignoreAll = true;
                res.ignoreIds = BulkOperationUtils.deserializeIgnoreIds(s[1]);
                break;
            }
            case "ignore": {
                res.ignore = true;
                res.ignoreIds = BulkOperationUtils.deserializeIgnoreIds(s[1]);
            }
        }
        return res;
    }

    public static ResponseMessage createFinalResponse(Choice choice, CompiledObject.Operation operation) {
        ResponseMessage message = new ResponseMessage();
        if (choice.getErrorIdsCount() == 0) {
            message.setText("net.n2oapp.framework.ui.dialogs.bulk.successAll");
            message.setData(Arrays.asList(operation.getName(), choice.getIdsCount()));
            message.setSeverityType(SeverityType.success);
        } else if (choice.getErrorIdsCount() == choice.getIdsCount()) {
            message.setText("net.n2oapp.framework.ui.dialogs.bulk.failAll");
            message.setData(Arrays.asList(operation.getName(), choice.getIdsCount()));
            message.setSeverityType(SeverityType.danger);
        } else {
            message.setText("net.n2oapp.framework.ui.dialogs.bulk.success");
            message.setData(Arrays.asList(operation.getName(), choice.getSuccessIdsCount(), choice.getIdsCount()));
            message.setSeverityType(SeverityType.info);
        }
        return message;
    }

    @Deprecated
    private static Map<String, String> createChoice(Map<String, Boolean> ignoreIds) {
        HashMap<String, String> res = new HashMap<String, String>();
        String serializedIgnoreIds = BulkOperationUtils.serializeIgnoreIds(ignoreIds);
        res.put("\u041f\u0440\u043e\u043f\u0443\u0441\u0442\u0438\u0442\u044c", "ignore_ids_" + serializedIgnoreIds);
        res.put("\u041f\u0440\u043e\u043f\u0443\u0441\u0442\u0438\u0442\u044c \u0432\u0441\u0435", "ignoreAll_ids_" + serializedIgnoreIds);
        res.put("\u041f\u0440\u0435\u0440\u0432\u0430\u0442\u044c", ABORT);
        return res;
    }

    private static String serializeIgnoreIds(Map<String, Boolean> ignoreIds) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String key : ignoreIds.keySet()) {
            if (!first) {
                sb.append(',');
            }
            sb.append(key);
            sb.append(':');
            sb.append(ignoreIds.get(key));
            first = false;
        }
        return sb.toString();
    }

    private static Map<String, Boolean> deserializeIgnoreIds(String ignoreIds) {
        String[] idAndSuccessPairs;
        if (ignoreIds == null || ignoreIds.length() < 1) {
            return Collections.emptyMap();
        }
        HashMap<String, Boolean> res = new HashMap<String, Boolean>();
        for (String idAndSuccessPair : idAndSuccessPairs = ignoreIds.split(",")) {
            String[] tmp = idAndSuccessPair.split(":");
            res.put(tmp[0], Boolean.valueOf(tmp[1]));
        }
        return res;
    }

    public static class Choice {
        Map<String, Boolean> ignoreIds = new HashMap<String, Boolean>();
        private boolean ignoreAll = false;
        private boolean ignore = false;
        private boolean confirmationPast = false;

        public boolean isConfirmationPast() {
            return this.confirmationPast;
        }

        public boolean isIgnoreAll() {
            return this.ignoreAll;
        }

        public boolean isIgnore() {
            return this.ignore;
        }

        public Map<String, Boolean> getIgnoreIdsMap() {
            return this.ignoreIds;
        }

        public int getSuccessIdsCount() {
            int i = 0;
            for (String id : this.getIgnoreIdsMap().keySet()) {
                if (!this.ignoreIds.get(id).booleanValue()) continue;
                ++i;
            }
            return i;
        }

        public int getErrorIdsCount() {
            return this.getIdsCount() - this.getSuccessIdsCount();
        }

        public int getIdsCount() {
            return this.ignoreIds.size();
        }
    }
}

