/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.ui.controller.action;

import java.util.List;
import java.util.Map;
import net.n2oapp.criteria.dataset.DataSet;
import net.n2oapp.framework.api.MetadataEnvironment;
import net.n2oapp.framework.api.rest.ControllerType;
import net.n2oapp.framework.api.rest.SetDataResponse;
import net.n2oapp.framework.api.ui.ActionRequestInfo;
import net.n2oapp.framework.api.ui.ActionResponseInfo;
import net.n2oapp.framework.api.ui.ResponseMessage;
import net.n2oapp.framework.engine.data.N2oOperationProcessor;
import net.n2oapp.framework.engine.modules.stack.DataProcessingStack;
import net.n2oapp.framework.ui.controller.BulkOperationUtils;
import net.n2oapp.framework.ui.controller.action.SetController;
import org.springframework.stereotype.Controller;

@Controller
public class BulkActionController
extends SetController {
    public BulkActionController(DataProcessingStack dataProcessingStack, N2oOperationProcessor actionProcessor, MetadataEnvironment environment) {
        super(dataProcessingStack, actionProcessor, environment);
    }

    @Override
    public SetDataResponse execute(ActionRequestInfo requestInfo, ActionResponseInfo responseInfo) {
        return this.constructSuccessSetDataResponse((ActionRequestInfo<List<DataSet>>)requestInfo, responseInfo);
    }

    private ResponseMessage handleBulkActionRequest(ActionRequestInfo<List<DataSet>> bulkRequestInfo, ActionResponseInfo responseInfo) {
        BulkOperationUtils.Choice choice = BulkOperationUtils.deserializeChoice(bulkRequestInfo.getChoice());
        Map<String, Boolean> ignoreIds = choice.getIgnoreIdsMap();
        for (ActionRequestInfo requestInfo : bulkRequestInfo.toList()) {
            String id = ((DataSet)requestInfo.getData()).getId();
            if (ignoreIds.containsKey(id)) continue;
            try {
                this.handleActionRequest((ActionRequestInfo<DataSet>)requestInfo, responseInfo);
                ignoreIds.put(id, true);
            }
            catch (Exception e) {
                ignoreIds.put(id, false);
                if (choice.isIgnoreAll()) continue;
                BulkOperationUtils.throwExceptionWithChoice(e, ignoreIds, id, bulkRequestInfo.getOperation());
            }
        }
        return BulkOperationUtils.createFinalResponse(choice, bulkRequestInfo.getOperation());
    }

    private SetDataResponse constructSuccessSetDataResponse(ActionRequestInfo<List<DataSet>> requestInfo, ActionResponseInfo responseInfo) {
        SetDataResponse response = new SetDataResponse();
        response.addResponseMessage(this.handleBulkActionRequest(requestInfo, responseInfo), requestInfo.getSuccessAlertWidgetId());
        return response;
    }

    public ControllerType getControllerType() {
        return ControllerType.bulkOperation;
    }
}

