/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.ui.controller.action;

import net.n2oapp.criteria.dataset.DataSet;
import net.n2oapp.framework.api.MetadataEnvironment;
import net.n2oapp.framework.api.data.DomainProcessor;
import net.n2oapp.framework.api.exception.N2oException;
import net.n2oapp.framework.api.metadata.local.CompiledObject;
import net.n2oapp.framework.api.rest.ControllerTypeAware;
import net.n2oapp.framework.api.rest.SetDataResponse;
import net.n2oapp.framework.api.ui.ActionRequestInfo;
import net.n2oapp.framework.api.ui.ActionResponseInfo;
import net.n2oapp.framework.engine.data.N2oOperationProcessor;
import net.n2oapp.framework.engine.modules.stack.DataProcessingStack;

public abstract class SetController
implements ControllerTypeAware {
    private DataProcessingStack dataProcessingStack;
    private DomainProcessor domainsProcessor;
    private N2oOperationProcessor actionProcessor;

    public SetController(DataProcessingStack dataProcessingStack, N2oOperationProcessor actionProcessor, MetadataEnvironment environment) {
        this.dataProcessingStack = dataProcessingStack;
        this.domainsProcessor = environment.getDomainProcessor();
        this.actionProcessor = actionProcessor;
    }

    public abstract SetDataResponse execute(ActionRequestInfo var1, ActionResponseInfo var2);

    protected DataSet handleActionRequest(ActionRequestInfo<DataSet> requestInfo, ActionResponseInfo responseInfo) {
        DataSet inDataSet = (DataSet)requestInfo.getData();
        CompiledObject.Operation operation = requestInfo.getOperation();
        this.dataProcessingStack.processAction(requestInfo, responseInfo, inDataSet);
        try {
            DataSet resDataSet = this.actionProcessor.invoke(operation, inDataSet, requestInfo.getInParametersMap().values(), requestInfo.getOutParametersMap().values());
            this.dataProcessingStack.processActionResult(requestInfo, responseInfo, resDataSet);
            responseInfo.prepare(inDataSet);
            return resDataSet;
        }
        catch (N2oException e) {
            this.dataProcessingStack.processActionError(requestInfo, responseInfo, inDataSet, e);
            responseInfo.prepare(inDataSet);
            throw e;
        }
        catch (Exception exception) {
            throw new N2oException((Throwable)exception, requestInfo.getFailAlertWidgetId());
        }
    }
}

