/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.ui.controller.query;

import java.util.Map;
import net.n2oapp.criteria.api.CollectionPage;
import net.n2oapp.criteria.dataset.DataSet;
import net.n2oapp.framework.api.MetadataEnvironment;
import net.n2oapp.framework.api.data.QueryProcessor;
import net.n2oapp.framework.api.exception.N2oException;
import net.n2oapp.framework.api.exception.SeverityType;
import net.n2oapp.framework.api.rest.ControllerTypeAware;
import net.n2oapp.framework.api.rest.GetDataResponse;
import net.n2oapp.framework.api.ui.ErrorMessageBuilder;
import net.n2oapp.framework.api.ui.QueryRequestInfo;
import net.n2oapp.framework.api.ui.QueryResponseInfo;
import net.n2oapp.framework.api.ui.ResponseMessage;
import net.n2oapp.framework.api.util.SubModelsProcessor;
import net.n2oapp.framework.engine.exception.N2oRecordNotFoundException;
import net.n2oapp.framework.engine.modules.stack.DataProcessingStack;

public abstract class GetController
implements ControllerTypeAware {
    private DataProcessingStack dataProcessingStack;
    private QueryProcessor queryProcessor;
    private SubModelsProcessor subModelsProcessor;
    private ErrorMessageBuilder errorMessageBuilder;

    protected GetController(DataProcessingStack dataProcessingStack, QueryProcessor queryProcessor, SubModelsProcessor subModelsProcessor, ErrorMessageBuilder errorMessageBuilder, MetadataEnvironment environment) {
        this.dataProcessingStack = dataProcessingStack;
        this.queryProcessor = queryProcessor;
        this.subModelsProcessor = subModelsProcessor;
        this.errorMessageBuilder = errorMessageBuilder;
    }

    public abstract GetDataResponse execute(QueryRequestInfo var1, QueryResponseInfo var2);

    public CollectionPage<DataSet> executeQuery(QueryRequestInfo requestInfo, QueryResponseInfo responseInfo) {
        CollectionPage pageData = null;
        this.dataProcessingStack.processQuery(requestInfo, responseInfo);
        try {
            pageData = this.queryProcessor.execute(requestInfo.getQuery(), requestInfo.getCriteria());
            this.executeSubModels(requestInfo, (CollectionPage<DataSet>)pageData, responseInfo);
        }
        catch (N2oException e) {
            this.dataProcessingStack.processQueryError(requestInfo, responseInfo, e);
            throw e;
        }
        catch (Exception e) {
            throw new N2oException((Throwable)e, requestInfo.getFailAlertWidgetId());
        }
        this.dataProcessingStack.processQueryResult(requestInfo, responseInfo, pageData);
        return pageData;
    }

    private void executeSubModels(QueryRequestInfo requestInfo, CollectionPage<DataSet> page, QueryResponseInfo responseInfo) {
        if (!page.getCollection().isEmpty() && requestInfo.isSubModelsExists() && requestInfo.getSize() == 1) {
            DataSet dataSet = (DataSet)page.getCollection().iterator().next();
            this.subModelsProcessor.executeSubModels(requestInfo.getQuery().getSubModelQueries(), dataSet);
        }
    }

    public DataProcessingStack getDataProcessingStack() {
        return this.dataProcessingStack;
    }

    public QueryProcessor getQueryProcessor() {
        return this.queryProcessor;
    }

    public SubModelsProcessor getSubModelsProcessor() {
        return this.subModelsProcessor;
    }

    public ErrorMessageBuilder getErrorMessageBuilder() {
        return this.errorMessageBuilder;
    }

    public static class RecordNotFoundCollector
    implements SubModelsProcessor.OnErrorCallback {
        private QueryResponseInfo responseInfo;

        public RecordNotFoundCollector(QueryResponseInfo responseInfo) {
            this.responseInfo = responseInfo;
        }

        public void onError(RuntimeException e, Map<String, Object> dataSet, String controlId) {
            if (e instanceof N2oRecordNotFoundException) {
                dataSet.put(controlId, null);
                ResponseMessage message = new ResponseMessage();
                message.setText("{n2o.fillingErrorValueIsAbsent}");
                message.setSeverityType(SeverityType.danger);
                message.setField(controlId);
                this.responseInfo.addMessage(message);
            } else {
                ResponseMessage message = new ResponseMessage();
                message.setText("{n2o.fillingErrorDataLoadException}");
                message.setSeverityType(SeverityType.danger);
                message.setField(controlId);
                this.responseInfo.addMessage(message);
            }
        }
    }
}

