/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.ui.controller.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.n2oapp.criteria.api.CollectionPage;
import net.n2oapp.criteria.dataset.DataSet;
import net.n2oapp.framework.api.MetadataEnvironment;
import net.n2oapp.framework.api.criteria.N2oPreparedCriteria;
import net.n2oapp.framework.api.data.QueryProcessor;
import net.n2oapp.framework.api.exception.N2oException;
import net.n2oapp.framework.api.rest.ControllerType;
import net.n2oapp.framework.api.rest.GetDataResponse;
import net.n2oapp.framework.api.ui.ErrorMessageBuilder;
import net.n2oapp.framework.api.ui.QueryRequestInfo;
import net.n2oapp.framework.api.ui.QueryResponseInfo;
import net.n2oapp.framework.api.util.SubModelsProcessor;
import net.n2oapp.framework.engine.exception.N2oRecordNotFoundException;
import net.n2oapp.framework.engine.modules.stack.DataProcessingStack;
import net.n2oapp.framework.ui.controller.query.GetController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;

@Controller
public class QueryController
extends GetController {
    private static final String INSERTED_ROW = "$insertedRow";
    private static final Logger logger = LoggerFactory.getLogger(QueryController.class);

    public QueryController(DataProcessingStack dataProcessingStack, QueryProcessor queryProcessor, SubModelsProcessor subModelsProcessor, ErrorMessageBuilder errorMessageBuilder, MetadataEnvironment environment) {
        super(dataProcessingStack, queryProcessor, subModelsProcessor, errorMessageBuilder, environment);
    }

    @Override
    public GetDataResponse execute(QueryRequestInfo requestInfo, QueryResponseInfo responseInfo) {
        try {
            CollectionPage<DataSet> collectionPage = this.executeQuery(requestInfo, responseInfo);
            this.insertSelectedRow(requestInfo, responseInfo, collectionPage);
            return new GetDataResponse(collectionPage, responseInfo, requestInfo.getSuccessAlertWidgetId());
        }
        catch (N2oException e) {
            String widgetId = requestInfo.getFailAlertWidgetId() == null ? requestInfo.getMessagesForm() : requestInfo.getFailAlertWidgetId();
            GetDataResponse response = new GetDataResponse(this.getErrorMessageBuilder().buildMessages((Exception)((Object)e)), widgetId);
            response.setStatus(e.getHttpStatus());
            logger.error("Error response " + response.getStatus() + " " + e.getSeverity(), (Throwable)e);
            return response;
        }
    }

    public ControllerType getControllerType() {
        return ControllerType.query;
    }

    private void insertSelectedRow(QueryRequestInfo requestInfo, QueryResponseInfo responseInfo, CollectionPage<DataSet> pageData) {
        if (requestInfo.getSelectedId() == null) {
            return;
        }
        if (requestInfo.getSize() == 1) {
            return;
        }
        List list = pageData.getCollection();
        if (this.findSelectedRow(requestInfo, list)) {
            return;
        }
        DataSet selectedRow = this.executeSelectedRow(requestInfo, responseInfo);
        if (selectedRow == null) {
            return;
        }
        ArrayList<Object> modifiedList = new ArrayList<Object>();
        modifiedList.add(selectedRow);
        if (!list.isEmpty()) {
            List trueList = list.size() >= requestInfo.getCriteria().getSize() ? new ArrayList(list).subList(0, requestInfo.getCriteria().getSize() - 1) : list;
            modifiedList.addAll(trueList);
        }
        pageData.setCollection(modifiedList);
    }

    private DataSet executeSelectedRow(QueryRequestInfo requestInfo, QueryResponseInfo responseInfo) {
        CollectionPage selectedRowPage;
        QueryRequestInfo selectedRowReqInfo = this.createQueryRequestInfoForSelectedRow(requestInfo);
        this.getDataProcessingStack().processQuery(selectedRowReqInfo, responseInfo);
        try {
            selectedRowPage = this.getQueryProcessor().execute(selectedRowReqInfo.getQuery(), selectedRowReqInfo.getCriteria());
            this.getDataProcessingStack().processQueryResult(selectedRowReqInfo, responseInfo, selectedRowPage);
        }
        catch (N2oRecordNotFoundException e) {
            logger.warn("selected-row return empty collection for query [" + selectedRowReqInfo.getQuery().getId() + "]", (Throwable)e);
            return null;
        }
        catch (N2oException e) {
            logger.error("selected-row throw exception for query [" + selectedRowReqInfo.getQuery().getId() + "]", (Throwable)e);
            this.getDataProcessingStack().processQueryError(selectedRowReqInfo, responseInfo, e);
            return null;
        }
        if (selectedRowPage.getCollection().isEmpty()) {
            return null;
        }
        DataSet selectedRow = (DataSet)selectedRowPage.getCollection().iterator().next();
        selectedRow.put(INSERTED_ROW, (Object)true);
        return selectedRow;
    }

    private boolean findSelectedRow(QueryRequestInfo requestInfo, Collection<DataSet> list) {
        for (DataSet dataset : list) {
            if (dataset.getId() == null || !dataset.getId().equals(requestInfo.getSelectedId().toString())) continue;
            return true;
        }
        return false;
    }

    private QueryRequestInfo createQueryRequestInfoForSelectedRow(QueryRequestInfo requestInfo) {
        QueryRequestInfo selectedRowReqInfo = new QueryRequestInfo();
        selectedRowReqInfo.setUser(requestInfo.getUser());
        selectedRowReqInfo.setQuery(requestInfo.getQuery());
        selectedRowReqInfo.setData(requestInfo.getData());
        selectedRowReqInfo.setUpload(requestInfo.getUpload());
        selectedRowReqInfo.setSize(1);
        selectedRowReqInfo.setCriteria(N2oPreparedCriteria.simpleCriteriaOneRecord((String)"id", (Object)requestInfo.getSelectedId()));
        return selectedRowReqInfo;
    }
}

