/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.ui.servlet;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.n2oapp.framework.api.MetadataEnvironment;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.header.Header;
import net.n2oapp.framework.api.metadata.header.N2oHeader;
import net.n2oapp.framework.api.metadata.pipeline.ReadCompileBindTerminalPipeline;
import net.n2oapp.framework.api.register.SourceInfo;
import net.n2oapp.framework.config.metadata.compile.context.HeaderContext;
import net.n2oapp.framework.ui.servlet.AppConfigJsonWriter;
import net.n2oapp.framework.ui.servlet.ExposedResourceBundleMessageSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.MessageSourceAccessor;

public class AppConfigServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(AppConfigServlet.class);
    private AppConfigJsonWriter appConfigJsonWriter;
    private ExposedResourceBundleMessageSource messageSource;
    private ReadCompileBindTerminalPipeline pipeline;
    private MetadataEnvironment environment;
    private String headerSourceId;

    public void init() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse res) throws IOException {
        HashMap<String, Object> addedValues = new HashMap<String, Object>();
        addedValues.put("menu", this.getMenu());
        addedValues.put("messages", this.getMessages());
        res.setContentType("application/json");
        try (PrintWriter out = res.getWriter();){
            this.appConfigJsonWriter.writeValues(out, addedValues);
        }
    }

    private Map<String, Object> getMenu() {
        return (Map)new ObjectMapper().convertValue((Object)this.getHeader(), Map.class);
    }

    private Header getHeader() {
        if (this.headerSourceId != null && !this.headerSourceId.isEmpty()) {
            return (Header)this.pipeline.get((CompileContext)new HeaderContext(this.headerSourceId), null);
        }
        List headers = this.environment.getMetadataRegister().find(N2oHeader.class);
        if (headers == null || headers.isEmpty()) {
            return (Header)this.pipeline.get((CompileContext)new HeaderContext("default"), null);
        }
        return (Header)this.pipeline.get((CompileContext)new HeaderContext(((SourceInfo)headers.get(0)).getId()), null);
    }

    private Map<String, String> getMessages() {
        MessageSourceAccessor accessor = new MessageSourceAccessor((MessageSource)this.messageSource);
        Locale locale = LocaleContextHolder.getLocale();
        Set messagesBaseNames = this.messageSource.getBasenameSet();
        TreeMap<String, String> map = new TreeMap<String, String>();
        for (String baseName : messagesBaseNames) {
            Set<String> keys = this.messageSource.getKeys(baseName, locale);
            for (String key : keys) {
                map.put(key, accessor.getMessage(key, locale));
            }
        }
        return map;
    }

    public void setAppConfigJsonWriter(AppConfigJsonWriter appConfigJsonWriter) {
        this.appConfigJsonWriter = appConfigJsonWriter;
    }

    public AppConfigJsonWriter getAppConfigJsonWriter() {
        return this.appConfigJsonWriter;
    }

    public void setMessageSource(ExposedResourceBundleMessageSource messageSource) {
        this.messageSource = messageSource;
    }

    public void setPipeline(ReadCompileBindTerminalPipeline pipeline) {
        this.pipeline = pipeline;
    }

    public void setHeaderSourceId(String headerSourceId) {
        this.headerSourceId = headerSourceId;
    }

    public void setEnvironment(MetadataEnvironment environment) {
        this.environment = environment;
    }
}

