/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.ui.servlet;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class MetadataXsdDownloadServlet
extends HttpServlet {
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String schemaPath = request.getPathInfo();
        if (schemaPath == null) {
            response.sendError(404);
            return;
        }
        if (schemaPath.endsWith(".xsd")) {
            schemaPath = schemaPath.substring(0, schemaPath.indexOf(".xsd"));
        }
        schemaPath = schemaPath + ".xsd";
        String fileType = "application/octet-stream";
        response.setContentType(fileType);
        int idx = schemaPath.lastIndexOf("/");
        String fileName = schemaPath.substring(idx + 1);
        response.setHeader("Content-disposition", "attachment; filename=" + fileName);
        try (ServletOutputStream out = response.getOutputStream();
             InputStream in = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("net/n2oapp/framework/config/schema" + schemaPath);){
            int length;
            if (in == null) {
                response.sendError(404);
                return;
            }
            byte[] buffer = new byte[1024];
            while ((length = in.read(buffer)) > 0) {
                out.write(buffer, 0, length);
            }
        }
    }
}

