/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.platform.jaxrs.autoconfigure;

import java.lang.reflect.Field;
import java.lang.reflect.Proxy;
import org.apache.cxf.Bus;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.jaxrs.client.Client;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.jaxrs.client.spring.JaxRsProxyClientConfiguration;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.util.ReflectionUtils;

public class JaxRsProxyClientFactoryBean
extends JaxRsProxyClientConfiguration
implements FactoryBean {
    private Class<?> serviceClass;
    private String connectionTimeout;
    private String receiveTimeout;

    public Object getObject() {
        Client client = this.createClient();
        HTTPClientPolicy httpClientPolicy = WebClient.getConfig((Object)client).getHttpConduit().getClient();
        if (!StringUtils.isEmpty((String)this.connectionTimeout)) {
            httpClientPolicy.setConnectionTimeout(Long.parseLong(this.connectionTimeout));
        }
        if (!StringUtils.isEmpty((String)this.receiveTimeout)) {
            httpClientPolicy.setReceiveTimeout(Long.parseLong(this.receiveTimeout));
        }
        return client;
    }

    public Class<?> getObjectType() {
        return this.serviceClass != null ? Proxy.getProxyClass(((Object)((Object)this)).getClass().getClassLoader(), this.serviceClass) : null;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setServiceClass(Class<?> serviceClass) {
        this.serviceClass = serviceClass;
    }

    public void setBus(Bus bus) {
        this.setPrivate("bus", bus);
    }

    public void setAddress(String address) {
        this.setPrivate("address", address);
    }

    public void setThreadSafe(Boolean threadSafe) {
        this.setPrivate("threadSafe", threadSafe);
    }

    public void setAccept(String accept) {
        this.setPrivate("accept", accept);
    }

    public void setContentType(String contentType) {
        this.setPrivate("contentType", contentType);
    }

    public void setConnectionTimeout(String connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public void setReceiveTimeout(String receiveTimeout) {
        this.receiveTimeout = receiveTimeout;
    }

    protected Class<?> getServiceClass() {
        return this.serviceClass;
    }

    private void setPrivate(String fieldName, Object value) {
        Field field = ReflectionUtils.findField(((Object)((Object)this)).getClass(), (String)fieldName);
        ReflectionUtils.makeAccessible((Field)field);
        ReflectionUtils.setField((Field)field, (Object)((Object)this), (Object)value);
    }
}

