/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.platform.jaxrs.autoconfigure;

import brave.Tracing;
import io.swagger.models.auth.OAuth2Definition;
import java.util.Map;
import javax.validation.ValidatorFactory;
import net.n2oapp.platform.i18n.Messages;
import net.n2oapp.platform.jaxrs.MessageExceptionMapper;
import net.n2oapp.platform.jaxrs.ViolationRestExceptionMapper;
import net.n2oapp.platform.jaxrs.autoconfigure.AnnotatedLoggingInInterceptor;
import net.n2oapp.platform.jaxrs.autoconfigure.AnnotatedLoggingOutInterceptor;
import net.n2oapp.platform.jaxrs.autoconfigure.JaxRsProperties;
import net.n2oapp.platform.jaxrs.autoconfigure.RestServerExceptionMapper;
import org.apache.cxf.ext.logging.LoggingInInterceptor;
import org.apache.cxf.ext.logging.LoggingOutInterceptor;
import org.apache.cxf.jaxrs.swagger.Swagger2Feature;
import org.apache.cxf.jaxrs.validation.JAXRSBeanValidationInInterceptor;
import org.apache.cxf.spring.boot.autoconfigure.CxfAutoConfiguration;
import org.apache.cxf.spring.boot.autoconfigure.CxfProperties;
import org.apache.cxf.tracing.brave.jaxrs.BraveFeature;
import org.apache.cxf.validation.BeanValidationInInterceptor;
import org.apache.cxf.validation.BeanValidationProvider;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnWebApplication
@AutoConfigureBefore(value={CxfAutoConfiguration.class})
@EnableConfigurationProperties(value={JaxRsProperties.class})
public class JaxRsServerAutoConfiguration {
    private final JaxRsProperties jaxRsProperties;
    private final CxfProperties cxfProperties;

    public JaxRsServerAutoConfiguration(CxfProperties cxfProperties, JaxRsProperties jaxRsProperties) {
        this.cxfProperties = cxfProperties;
        this.jaxRsProperties = jaxRsProperties;
    }

    @Bean(value={"swagger2Feature"})
    @ConditionalOnProperty(prefix="jaxrs.swagger", name={"enabled"}, matchIfMissing=true)
    Swagger2Feature swagger2Feature() {
        Swagger2Feature result = new Swagger2Feature();
        result.setTitle(this.jaxRsProperties.getSwagger().getTitle());
        result.setDescription(this.jaxRsProperties.getSwagger().getDescription());
        result.setBasePath(this.cxfProperties.getPath());
        result.setVersion(this.jaxRsProperties.getSwagger().getVersion());
        result.setSchemes(this.jaxRsProperties.getSwagger().getSchemes());
        result.setPrettyPrint(Boolean.valueOf(true));
        JaxRsProperties.Swagger.Auth auth = this.jaxRsProperties.getSwagger().getAuth();
        if (auth != null && auth.getName() != null && auth.getTokenUri() != null) {
            OAuth2Definition oAuth2Definition = new OAuth2Definition();
            oAuth2Definition.setFlow(auth.getFlow());
            oAuth2Definition.setTokenUrl(auth.getTokenUri());
            result.setSecurityDefinitions(Map.of(auth.getName(), oAuth2Definition));
        }
        result.setResourcePackage(this.jaxRsProperties.getSwagger().getResourcePackage());
        return result;
    }

    @Bean
    @ConditionalOnProperty(prefix="jaxrs", name={"log-in", "logging-in.enabled"}, matchIfMissing=true)
    LoggingInInterceptor loggingInInterceptor() {
        AnnotatedLoggingInInterceptor loggingInInterceptor = new AnnotatedLoggingInInterceptor();
        loggingInInterceptor.setLimit(this.jaxRsProperties.getLoggingIn().getLimit());
        loggingInInterceptor.setInMemThreshold(this.jaxRsProperties.getLoggingIn().getInMemThreshold());
        loggingInInterceptor.setLogBinary(this.jaxRsProperties.getLoggingIn().isLogBinary());
        loggingInInterceptor.setLogMultipart(this.jaxRsProperties.getLoggingIn().isLogMultipart());
        loggingInInterceptor.setPrettyLogging(this.jaxRsProperties.getLoggingIn().isPrettyLogging());
        return loggingInInterceptor;
    }

    @Bean
    @ConditionalOnProperty(prefix="jaxrs", name={"log-out", "logging-out.enabled"}, matchIfMissing=true)
    LoggingOutInterceptor loggingOutInterceptor() {
        AnnotatedLoggingOutInterceptor loggingOutInterceptor = new AnnotatedLoggingOutInterceptor();
        loggingOutInterceptor.setLimit(this.jaxRsProperties.getLoggingOut().getLimit());
        loggingOutInterceptor.setInMemThreshold(this.jaxRsProperties.getLoggingOut().getInMemThreshold());
        loggingOutInterceptor.setLogBinary(this.jaxRsProperties.getLoggingOut().isLogBinary());
        loggingOutInterceptor.setLogMultipart(this.jaxRsProperties.getLoggingOut().isLogMultipart());
        loggingOutInterceptor.setPrettyLogging(this.jaxRsProperties.getLoggingOut().isPrettyLogging());
        return loggingOutInterceptor;
    }

    @Bean
    @ConditionalOnProperty(prefix="jaxrs", name={"jsr303"}, matchIfMissing=true)
    BeanValidationInInterceptor beanValidationInInterceptor(ValidatorFactory validatorFactory) {
        JAXRSBeanValidationInInterceptor validationInInterceptor = new JAXRSBeanValidationInInterceptor();
        BeanValidationProvider validationProvider = new BeanValidationProvider(validatorFactory);
        validationInInterceptor.setProvider(validationProvider);
        return validationInInterceptor;
    }

    @Bean
    ViolationRestExceptionMapper violationExceptionMapper() {
        return new ViolationRestExceptionMapper();
    }

    @Bean
    RestServerExceptionMapper restServerExceptionMapper() {
        return new RestServerExceptionMapper();
    }

    @Bean
    @ConditionalOnClass(value={Messages.class})
    MessageExceptionMapper messageExceptionMapper(Messages messages) {
        return new MessageExceptionMapper(messages);
    }

    @Bean
    @ConditionalOnProperty(value={"spring.sleuth.enabled"})
    BraveFeature braveFeature(Tracing brave) {
        return new BraveFeature(brave);
    }
}

