/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.platform.loader.client;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.net.URI;
import net.n2oapp.platform.loader.client.ClientLoader;
import org.springframework.core.io.Resource;

public class ClientLoaderCommand {
    @JsonIgnore
    private URI server;
    private String subject;
    private String target;
    @JsonIgnore
    private Resource file;
    @JsonIgnore
    private Class<? extends ClientLoader> loaderClass;
    @JsonIgnore
    private AuthDetails auth;

    public ClientLoaderCommand() {
    }

    public ClientLoaderCommand(URI server, String subject, String target, Resource file) {
        this.server = server;
        this.subject = subject;
        this.target = target;
        this.file = file;
    }

    public ClientLoaderCommand(URI server, String subject, String target, Resource file, Class<? extends ClientLoader> loaderClass) {
        this.server = server;
        this.subject = subject;
        this.target = target;
        this.file = file;
        this.loaderClass = loaderClass;
    }

    public String getServerUri() {
        return this.server.toString();
    }

    public String getFilename() {
        return this.file.getFilename();
    }

    public URI getServer() {
        return this.server;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getTarget() {
        return this.target;
    }

    public Resource getFile() {
        return this.file;
    }

    public void setServer(URI server) {
        this.server = server;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public void setFile(Resource file) {
        this.file = file;
    }

    public Class<? extends ClientLoader> getLoaderClass() {
        return this.loaderClass;
    }

    public void setLoaderClass(Class<? extends ClientLoader> loaderClass) {
        this.loaderClass = loaderClass;
    }

    public AuthDetails getAuth() {
        return this.auth;
    }

    public void setAuth(AuthDetails auth) {
        this.auth = auth;
    }

    public static class AuthDetails {
        private String type;
        private String username;
        private String password;
        private String tokenUri;

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getUsername() {
            return this.username;
        }

        public void setUsername(String username) {
            this.type = "basic";
            this.username = username;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public String getClientId() {
            return this.getUsername();
        }

        public void setClientId(String clientId) {
            this.type = "oauth2";
            this.username = clientId;
        }

        public String getClientSecret() {
            return this.getPassword();
        }

        public void setClientSecret(String clientSecret) {
            this.setPassword(clientSecret);
        }

        public String getTokenUri() {
            return this.tokenUri;
        }

        public void setTokenUri(String tokenUri) {
            this.tokenUri = tokenUri;
        }
    }
}

