/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.platform.loader.client;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.n2oapp.platform.loader.client.ClientLoaderCommand;

public class LoaderReport {
    private List<Fail> fails = new ArrayList<Fail>();
    private List<ClientLoaderCommand> success = new ArrayList<ClientLoaderCommand>();
    private List<ClientLoaderCommand> aborted = new ArrayList<ClientLoaderCommand>();

    public boolean isSuccess() {
        return this.fails.isEmpty() && this.aborted.isEmpty();
    }

    public void addFail(ClientLoaderCommand command, Exception e) {
        this.fails.add(new Fail(command, e));
    }

    public void addSuccess(ClientLoaderCommand command) {
        this.success.add(command);
    }

    public void addAborted(List<ClientLoaderCommand> commands) {
        this.aborted.addAll(commands);
    }

    public List<Fail> getFails() {
        return Collections.unmodifiableList(this.fails);
    }

    public List<ClientLoaderCommand> getSuccess() {
        return Collections.unmodifiableList(this.success);
    }

    public List<ClientLoaderCommand> getAborted() {
        return Collections.unmodifiableList(this.aborted);
    }

    public static class Fail {
        private ClientLoaderCommand command;
        @JsonIgnore
        private Exception exception;

        public Fail(ClientLoaderCommand command, Exception exception) {
            this.command = command;
            this.exception = exception;
        }

        public ClientLoaderCommand getCommand() {
            return this.command;
        }

        public Exception getException() {
            return this.exception;
        }

        public String getMessage() {
            return this.exception.getMessage();
        }
    }
}

