/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.platform.loader.client;

import net.n2oapp.platform.loader.client.ClientLoaderRunner;
import net.n2oapp.platform.loader.client.LoaderReport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoaderStarter {
    private static final Logger logger = LoggerFactory.getLogger(LoaderStarter.class);
    private ClientLoaderRunner runner;
    private LoaderReport report;

    public LoaderStarter(ClientLoaderRunner runner) {
        this.runner = runner;
        this.report = new LoaderReport();
    }

    public synchronized void start() {
        logger.info("Loading started...");
        this.report = this.runner.run();
        if (this.report.isSuccess()) {
            logger.info("Loading success finished!");
        } else {
            if (logger.isErrorEnabled()) {
                logger.error(String.format("Loading failed: %d fails, %d success, %d aborted.", this.report.getFails().size(), this.report.getSuccess().size(), this.report.getAborted().size()));
            }
            this.report.getFails().forEach(fail -> logger.debug(String.format("Loading %s failed by %s", fail.getCommand().getTarget(), fail.getException().getMessage()), (Throwable)fail.getException()));
        }
    }

    public LoaderReport getReport() {
        return this.report;
    }
}

