/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.platform.loader.client;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.n2oapp.platform.loader.client.ClientLoader;
import net.n2oapp.platform.loader.client.ClientLoaderCommand;
import net.n2oapp.platform.loader.client.LoaderReport;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public class ClientLoaderRunner {
    private List<ClientLoader> loaders;
    private List<ClientLoaderCommand> commands = new ArrayList<ClientLoaderCommand>();
    private boolean failFast = true;

    public ClientLoaderRunner(List<ClientLoader> loaders) {
        if (loaders == null || loaders.isEmpty()) {
            throw new IllegalArgumentException("Loaders required");
        }
        this.loaders = loaders;
    }

    public ClientLoaderRunner add(ClientLoaderCommand command) {
        this.commands.add(command);
        return this;
    }

    public ClientLoaderRunner add(String serverUrl, String subject, String target, Resource fileUri, Class<? extends ClientLoader> loaderClass) {
        try {
            this.commands.add(new ClientLoaderCommand(new URI(serverUrl), subject, target, fileUri, loaderClass));
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
        return this;
    }

    public ClientLoaderRunner add(String serverUrl, String subject, String target, String filePath) {
        return this.add(serverUrl, subject, target, (Resource)new ClassPathResource(filePath), null);
    }

    public ClientLoaderRunner add(String serverUrl, String subject, String target, String filePath, Class<? extends ClientLoader> loaderClass) {
        return this.add(serverUrl, subject, target, (Resource)new ClassPathResource(filePath), loaderClass);
    }

    public LoaderReport run() {
        LoaderReport report = new LoaderReport();
        for (ClientLoaderCommand command : this.commands) {
            try {
                this.find(command.getLoaderClass()).load(command.getServer(), command.getSubject(), command.getTarget(), command.getFile());
                report.addSuccess(command);
            }
            catch (Exception e) {
                report.addFail(command, e);
                if (!this.failFast) continue;
                int i = this.commands.indexOf(command);
                if (i >= this.commands.size() - 1) break;
                report.addAborted(this.commands.subList(i + 1, this.commands.size()));
                break;
            }
        }
        return report;
    }

    protected ClientLoader find(Class<? extends ClientLoader> loaderClass) {
        if (loaderClass != null) {
            Optional<ClientLoader> loader = this.loaders.stream().filter(l -> l.getClass().equals(loaderClass)).findFirst();
            if (loader.isPresent()) {
                return loader.get();
            }
            throw new IllegalArgumentException("Loader bean " + loaderClass + " not found");
        }
        return this.loaders.get(0);
    }

    public void setFailFast(boolean failFast) {
        this.failFast = failFast;
    }

    public List<ClientLoader> getLoaders() {
        return Collections.unmodifiableList(this.loaders);
    }

    public List<ClientLoaderCommand> getCommands() {
        return Collections.unmodifiableList(this.commands);
    }
}

