/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.platform.loader.client;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.stream.Collectors;
import net.n2oapp.platform.loader.client.RestClientLoader;
import org.springframework.core.io.Resource;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestOperations;

public class JsonClientLoader
extends RestClientLoader<String> {
    public JsonClientLoader(RestOperations restTemplate) {
        super(restTemplate);
    }

    @Override
    protected String getData(Resource file) {
        String data;
        if (this.getExtension(file.getFilename()).filter("json"::equalsIgnoreCase).isEmpty()) {
            throw new IllegalArgumentException("File " + file.getFilename() + " not a json");
        }
        try {
            data = new BufferedReader(new InputStreamReader(file.getInputStream(), StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return data;
    }

    @Override
    protected MultiValueMap<String, String> getHeaders() {
        LinkedMultiValueMap headers = new LinkedMultiValueMap();
        headers.add((Object)"Content-Type", (Object)"application/json");
        return headers;
    }

    private Optional<String> getExtension(String filename) {
        return Optional.ofNullable(filename).filter(f -> f.contains(".")).map(f -> f.substring(filename.lastIndexOf(46) + 1));
    }
}

