/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.platform.loader.client;

import java.net.URI;
import net.n2oapp.platform.loader.client.ClientLoader;
import net.n2oapp.platform.loader.client.LoadingException;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestOperations;

public abstract class RestClientLoader<T>
implements ClientLoader {
    private RestOperations restTemplate;
    private String endpointPattern = "/loaders/{subject}/{target}";

    public RestClientLoader(RestOperations restTemplate) {
        this.restTemplate = restTemplate;
    }

    public RestClientLoader(RestOperations restTemplate, String endpointPattern) {
        this.restTemplate = restTemplate;
        this.endpointPattern = endpointPattern;
    }

    @Override
    public void load(URI server, String subject, String target, Resource file) {
        T data = this.getData(file);
        HttpEntity request = new HttpEntity(data, this.getHeaders());
        ResponseEntity response = this.restTemplate.postForEntity(this.getUrl(server, subject, target), (Object)request, String.class, new Object[0]);
        if (!response.getStatusCode().is2xxSuccessful()) {
            throw new LoadingException("Loading failed status " + response.getStatusCodeValue() + " response " + (String)response.getBody());
        }
    }

    protected MultiValueMap<String, String> getHeaders() {
        return null;
    }

    protected abstract T getData(Resource var1);

    protected String getUrl(URI server, String subject, String target) {
        String serverUrl = server.toString().endsWith("/") ? server.toString().substring(0, server.toString().length() - 1) : server.toString();
        return serverUrl + this.endpointPattern.replace("{subject}", subject).replace("{target}", target);
    }

    public RestOperations getRestTemplate() {
        return this.restTemplate;
    }

    public void setEndpointPattern(String endpointPattern) {
        this.endpointPattern = endpointPattern;
    }
}

