/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.platform.loader.client.auth;

import java.io.IOException;
import java.net.URI;
import java.util.Map;
import net.n2oapp.platform.loader.client.auth.ClientContext;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.web.client.RestTemplate;

public class AuthRestTemplate
extends RestTemplate {
    private Map<String, ClientContext> contextStorage;

    public AuthRestTemplate(Map<String, ClientContext> contextStorage) {
        this.contextStorage = contextStorage;
    }

    protected ClientHttpRequest createRequest(URI uri, HttpMethod method) throws IOException {
        String accessToken;
        ClientContext ctx;
        ClientHttpRequest req = super.createRequest(uri, method);
        if (this.contextStorage != null && (ctx = this.contextStorage.get(uri.toString())) != null && (accessToken = ctx.getAccessToken()) != null) {
            req.getHeaders().set("Authorization", String.format("%s %s", ctx.getTokenType(), accessToken));
        }
        return req;
    }
}

