/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.platform.loader.client.auth;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Map;
import net.n2oapp.platform.loader.client.auth.ClientContext;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class OAuth2ClientContext
implements ClientContext {
    private String clientId;
    private String clientSecret;
    private String tokenEndpoint;
    private RestTemplate template = new RestTemplate();
    private ObjectMapper mapper = new ObjectMapper();

    public OAuth2ClientContext(String clientId, String clientSecret, String tokenEndpoint) {
        Assert.notNull((Object)clientId, (String)"ClientId mustn't be null");
        Assert.notNull((Object)clientSecret, (String)"ClientSecret mustn't be null");
        Assert.notNull((Object)tokenEndpoint, (String)"TokenEndpoint mustn't be null");
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.tokenEndpoint = tokenEndpoint;
    }

    @Override
    public String getAccessToken() {
        Map body;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        headers.setBasicAuth(this.clientId, this.clientSecret);
        LinkedMultiValueMap form = new LinkedMultiValueMap();
        form.add((Object)"grant_type", (Object)"client_credentials");
        HttpEntity request = new HttpEntity((Object)form, (MultiValueMap)headers);
        ResponseEntity resp = this.template.postForEntity(this.tokenEndpoint, (Object)request, String.class, new Object[0]);
        try {
            body = (Map)this.mapper.readValue((String)resp.getBody(), (TypeReference)new TypeReference<Map<String, Object>>(){});
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        String accessToken = null;
        if (body != null) {
            accessToken = (String)body.get("access_token");
        }
        return accessToken;
    }

    @Override
    public String getTokenType() {
        return "Bearer";
    }
}

