/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.platform.web.autoconfigure;

import java.util.Collections;
import java.util.Map;
import org.apache.cxf.annotations.Provider;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.oauth2.client.OAuth2RestTemplate;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.util.StringUtils;

@Provider(value=Provider.Type.OutInterceptor)
public class JaxRsJwtHeaderInterceptor
extends AbstractPhaseInterceptor<Message> {
    @Autowired(required=false)
    private OAuth2RestTemplate restTemplate;

    public JaxRsJwtHeaderInterceptor() {
        super("write");
    }

    public void handleMessage(Message message) {
        OAuth2AccessToken accessToken;
        if (this.restTemplate != null && (accessToken = this.restTemplate.getAccessToken()) != null) {
            String tokenType = accessToken.getTokenType();
            if (!StringUtils.hasText((String)tokenType)) {
                tokenType = "Bearer";
            }
            Map headers = (Map)message.get((Object)"org.apache.cxf.message.Message.PROTOCOL_HEADERS");
            headers.put("Authorization", Collections.singletonList(String.format("%s %s", tokenType, accessToken.getValue())));
        }
    }
}

