/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.properties.web;

import javax.servlet.ServletContext;
import net.n2oapp.properties.ExpressionBasedProperties;
import net.n2oapp.properties.OverrideProperties;
import net.n2oapp.properties.ReloadableProperties;
import net.n2oapp.properties.reader.PropertiesReader;
import net.n2oapp.properties.web.ServletPathProperties;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.web.context.ServletContextAware;

public class WebApplicationProperties
extends ExpressionBasedProperties
implements ServletContextAware {
    private String environmentPropertiesName;

    public WebApplicationProperties(String defaultPropertiesName, String buildPropertiesName, String environmentPropertiesName) {
        this.environmentPropertiesName = environmentPropertiesName;
        OverrideProperties buildProperties = PropertiesReader.getPropertiesFromClasspath(buildPropertiesName, defaultPropertiesName);
        ReloadableProperties environmentProperties = PropertiesReader.getReloadableFromClasspath(environmentPropertiesName, 60);
        environmentProperties.setBaseProperties(buildProperties);
        this.setBaseProperties(environmentProperties);
    }

    public void setClasspathPackage(String packageName) {
        this.getEnvProperties().setResource((Resource)new ClassPathResource(packageName + "/" + this.environmentPropertiesName));
        ServletPathProperties servletPathProperties = (ServletPathProperties)this.getServletProperties();
        if (servletPathProperties != null) {
            servletPathProperties.setClasspathPackage(packageName);
        }
    }

    public void setFilesystemFolder(String folderName) {
        this.getEnvProperties().setResource((Resource)new FileSystemResource(folderName + "/" + this.environmentPropertiesName));
        ServletPathProperties servletPathProperties = (ServletPathProperties)this.getServletProperties();
        if (servletPathProperties != null) {
            servletPathProperties.setFilesystemFolder(folderName);
        }
    }

    public void setEnvironment(ConfigurableEnvironment webAppEnvironment) {
        this.setEvaluationContext((EvaluationContext)new StandardEvaluationContext((Object)webAppEnvironment));
    }

    public void setServletContext(ServletContext servletContext) {
        ServletPathProperties servletPathProperties = new ServletPathProperties(servletContext, this.getBaseProperties());
        this.setBaseProperties(servletPathProperties);
    }

    public ReloadableProperties getServletProperties() {
        if (this.getBaseProperties() instanceof ServletPathProperties) {
            return (ServletPathProperties)this.getBaseProperties();
        }
        return null;
    }

    public ReloadableProperties getEnvProperties() {
        if (this.getServletProperties() != null) {
            return (ReloadableProperties)this.getServletProperties().getBaseProperties();
        }
        return (ReloadableProperties)this.getBaseProperties();
    }

    public OverrideProperties getBuildProperties() {
        return (OverrideProperties)this.getEnvProperties().getBaseProperties();
    }

    public OverrideProperties getDefaultProperties() {
        return (OverrideProperties)this.getBuildProperties().getBaseProperties();
    }

    public boolean envPropertiesIsExists() {
        return this.getEnvProperties().isExists();
    }

    public boolean servletPropertiesIsExists() {
        return this.getServletProperties() != null && this.getServletProperties().isExists();
    }

    public PropertyValue getFullPropertyValue(String property) {
        return new PropertyValue(this.getDefaultProperties().getCurrentLvlProperty(property), this.getBuildProperties().getCurrentLvlProperty(property), this.getEnvProperties().getCurrentLvlProperty(property), this.servletPropertiesIsExists() ? this.getServletProperties().getCurrentLvlProperty(property) : null, this.getProperty(property));
    }

    public static class PropertyValue {
        private String defaultValue;
        private String buildValue;
        private String envValue;
        private String servletValue;
        private String value;

        private PropertyValue(String defaultValue, String buildValue, String envValue, String servletValue, String value) {
            this.defaultValue = defaultValue;
            this.buildValue = buildValue;
            this.envValue = envValue;
            this.servletValue = servletValue;
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public String getBuildValue() {
            return this.buildValue;
        }

        public String getEnvValue() {
            return this.envValue;
        }

        public String getServletValue() {
            return this.servletValue;
        }
    }
}

