/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.properties;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.PropertySources;
import org.springframework.core.env.PropertySourcesPropertyResolver;

public class StaticProperties {
    private static final Function<String, String> DUMMY_MAPPER = s -> s;
    protected static PropertyResolver propertyResolver = null;

    public void setPropertyResolver(PropertyResolver propertyResolver) {
        if (StaticProperties.propertyResolver != null) {
            throw new IllegalStateException("static-properties can be initialized only once");
        }
        StaticProperties.propertyResolver = propertyResolver;
    }

    public void setPropertySources(PropertySources propertySources) {
        this.setPropertyResolver((PropertyResolver)new PropertySourcesPropertyResolver(propertySources));
    }

    public void setPropertySource(PropertySource<?> propertySource) {
        MutablePropertySources propertySources = new MutablePropertySources();
        propertySources.addFirst(propertySource);
        this.setPropertyResolver((PropertyResolver)new PropertySourcesPropertyResolver((PropertySources)propertySources));
    }

    public void setProperties(Properties properties) {
        this.setPropertySource((PropertySource<?>)new PropertiesPropertySource("static", properties));
    }

    public static boolean containsProperty(String key) {
        if (propertyResolver == null) {
            throw new IllegalStateException("cannot get value of property [" + key + "], because static properties is not yet initialized");
        }
        return propertyResolver.containsProperty(key);
    }

    public static String get(String key) {
        if (propertyResolver == null) {
            throw new IllegalStateException("cannot get value of property [" + key + "], because static properties is not yet initialized");
        }
        return propertyResolver.getProperty(key);
    }

    public static String getProperty(String key) {
        return StaticProperties.get(key);
    }

    public static boolean getBoolean(String key) {
        return Boolean.parseBoolean(StaticProperties.get(key));
    }

    public static int getInt(String key) {
        return Integer.parseInt(StaticProperties.get(key));
    }

    public static Integer getInteger(String key) {
        String value = StaticProperties.get(key);
        if (value == null) {
            return null;
        }
        return Integer.parseInt(value);
    }

    public static double getDouble(String key) {
        return Double.parseDouble(StaticProperties.get(key));
    }

    public static List<String> getList(String key) {
        return StaticProperties.getList(key, ",");
    }

    public static List<String> getList(String key, String separator) {
        return StaticProperties.getList(key, separator, DUMMY_MAPPER);
    }

    public static <T> List<T> getList(String key, String separator, Function<String, T> mapper) {
        String value = StaticProperties.get(key);
        if (value == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(value.split(Pattern.quote(separator))).stream().map(String::trim).map(mapper).collect(Collectors.toList());
    }

    public static boolean isEnabled(String key) {
        if (!key.endsWith(".enabled")) {
            throw new IllegalArgumentException("enabled-property must end with '.enabled'");
        }
        return StaticProperties.getBoolean(key);
    }

    public static <T extends Enum<?>> T getEnum(String key, Class<T> enumClass) {
        String value = StaticProperties.get(key);
        if (value == null || value.isEmpty()) {
            return null;
        }
        value = value.replaceAll("[\\W_]", "");
        Enum res = null;
        for (Enum enumValue : (Enum[])enumClass.getEnumConstants()) {
            if (!enumValue.name().replaceAll("[\\W_]", "").equalsIgnoreCase(value)) continue;
            res = enumValue;
        }
        return (T)res;
    }
}

