/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.properties.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.springframework.core.io.Resource;

public class PropertiesRewriter {
    public static final String KEY_VALUE_FORMAT = "%s=%s\n";

    private static <K> boolean isTarget(String str, K key) {
        return !str.startsWith("#") && PropertiesRewriter.hasKey(str) && PropertiesRewriter.getKey(str).equals(key.toString());
    }

    private static <K, V> String updateIfNeed(String str, K key, V value) {
        return PropertiesRewriter.isTarget(str, key) ? String.format(KEY_VALUE_FORMAT, key.toString(), value.toString()) : str;
    }

    private static String getKey(String str) {
        return str.split("[=\\s]")[0];
    }

    private static boolean hasKey(String str) {
        return str.contains("=") || str.contains(" ");
    }

    public static <K, V> void updateProperty(Resource resource, K key, V value) throws IOException {
        if (key == null || value == null) {
            throw new IllegalStateException();
        }
        List<String> lines = PropertiesRewriter.readResource(resource);
        try (FileWriter writer = new FileWriter(PropertiesRewriter.createFileIfNotExists(resource), false);){
            boolean found = false;
            for (String line : lines) {
                String tmp = PropertiesRewriter.updateIfNeed(line, key, value);
                writer.write(tmp);
                found = found || !tmp.equals(line);
            }
            if (!found) {
                writer.write("\n");
                writer.write(String.format(KEY_VALUE_FORMAT, key.toString(), value.toString()));
            }
            ((Writer)writer).flush();
        }
    }

    public static <K> void removeProperty(Resource resource, K key) throws IOException {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        List<String> lines = PropertiesRewriter.readResource(resource);
        try (FileWriter writer = new FileWriter(PropertiesRewriter.createFileIfNotExists(resource), false);){
            for (String line : lines) {
                if (PropertiesRewriter.isTarget(line, key)) continue;
                writer.write(line);
            }
            ((Writer)writer).flush();
        }
    }

    private static List<String> readResource(Resource resource) throws IOException {
        PropertiesRewriter.createFileIfNotExists(resource);
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(resource.getInputStream()));){
            String str;
            ArrayList<String> lines = new ArrayList<String>();
            while ((str = reader.readLine()) != null) {
                lines.add(str.concat("\n"));
            }
            ArrayList<String> arrayList = lines;
            return arrayList;
        }
    }

    private static File createFileIfNotExists(Resource resource) throws IOException {
        if (!resource.getFile().exists()) {
            PropertiesRewriter.createFile(resource);
        }
        return resource.getFile();
    }

    private static void createFile(Resource resource) throws IOException {
        File file = new File(resource.getURI());
        file.getParentFile().mkdirs();
        file.createNewFile();
    }
}

