/*
 * Decompiled with CFR 0.152.
 */
package net.nextencia.dj.swingsuite;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.Border;

class AutoScrollActivator {
    private AutoScrollProperties autoScrollProperties;
    private static final ImageIcon H_IMAGE_ICON = new ImageIcon(AutoScrollActivator.class.getResource("resource/autoscroll_h.png"));
    private static final ImageIcon V_IMAGE_ICON = new ImageIcon(AutoScrollActivator.class.getResource("resource/autoscroll_v.png"));
    private static final ImageIcon HV_IMAGE_ICON = new ImageIcon(AutoScrollActivator.class.getResource("resource/autoscroll_all.png"));
    private static AutoScrollMouseListener autoScrollMouseListener = new AutoScrollMouseListener();

    private AutoScrollActivator() {
    }

    private void deactivateAutoScroll() {
        this.autoScrollProperties.timer.stop();
        try {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this.autoScrollProperties.toolkitListener);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.autoScrollProperties.iconPopupMenu.setVisible(false);
        this.autoScrollProperties = null;
    }

    private void activateAutoScroll(MouseEvent e) {
        Component c;
        for (c = e.getComponent(); c != null && !(c instanceof JScrollPane); c = c.getParent()) {
        }
        if (c == null) {
            return;
        }
        this.autoScrollProperties = new AutoScrollProperties();
        this.autoScrollProperties.scrollPane = (JScrollPane)c;
        this.autoScrollProperties.isDragMode = false;
        JViewport viewport = this.autoScrollProperties.scrollPane.getViewport();
        this.autoScrollProperties.currentLocation = MouseInfo.getPointerInfo().getLocation();
        SwingUtilities.convertPointFromScreen(this.autoScrollProperties.currentLocation, viewport);
        this.autoScrollProperties.startLocation = this.autoScrollProperties.currentLocation;
        final JPopupMenu iconPopupMenu = new JPopupMenu(){

            @Override
            public void setBorder(Border border) {
            }
        };
        iconPopupMenu.setFocusable(false);
        iconPopupMenu.setOpaque(false);
        iconPopupMenu.setBorder(BorderFactory.createEmptyBorder());
        iconPopupMenu.setBackground(new Color(0, 0, 0, 0));
        JLabel iconLabel = new JLabel(this.getAutoScrollIcon());
        iconPopupMenu.add(iconLabel);
        iconPopupMenu.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                iconPopupMenu.setVisible(false);
            }
        });
        this.autoScrollProperties.iconPopupMenu = iconPopupMenu;
        Dimension iconPopupMenuSize = iconPopupMenu.getPreferredSize();
        iconPopupMenu.show(viewport, this.autoScrollProperties.startLocation.x - iconPopupMenuSize.width / 2, this.autoScrollProperties.startLocation.y - iconPopupMenuSize.height / 2);
        Container parent = iconPopupMenu.getParent();
        if (parent instanceof JComponent) {
            ((JComponent)parent).setBorder(null);
        }
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JViewport viewport = AutoScrollActivator.this.autoScrollProperties.scrollPane.getViewport();
                Component view = viewport.getView();
                if (view == null) {
                    return;
                }
                Point viewPosition = viewport.getViewPosition();
                int offsetX = ((AutoScrollActivator)AutoScrollActivator.this).autoScrollProperties.currentLocation.x - ((AutoScrollActivator)AutoScrollActivator.this).autoScrollProperties.startLocation.x;
                int offsetY = ((AutoScrollActivator)AutoScrollActivator.this).autoScrollProperties.currentLocation.y - ((AutoScrollActivator)AutoScrollActivator.this).autoScrollProperties.startLocation.y;
                offsetX = offsetX > 0 ? Math.max(0, offsetX - 4) : Math.min(0, offsetX + 4);
                offsetY = offsetY > 0 ? Math.max(0, offsetY - 4) : Math.min(0, offsetY + 4);
                viewPosition = new Point(viewPosition.x + offsetX, viewPosition.y + offsetY);
                Dimension extentSize = viewport.getExtentSize();
                Dimension viewSize = view.getSize();
                if (viewSize.width - viewPosition.x < extentSize.width) {
                    viewPosition.x = viewSize.width - extentSize.width;
                }
                if (viewSize.height - viewPosition.y < extentSize.height) {
                    viewPosition.y = viewSize.height - extentSize.height;
                }
                if (viewPosition.x < 0) {
                    viewPosition.x = 0;
                }
                if (viewPosition.y < 0) {
                    viewPosition.y = 0;
                }
                viewport.setViewPosition(viewPosition);
            }
        };
        this.autoScrollProperties.timer = new Timer(50, actionListener);
        this.autoScrollProperties.timer.start();
        this.autoScrollProperties.toolkitListener = new AWTEventListener(){

            @Override
            public void eventDispatched(AWTEvent e) {
                int eventID = e.getID();
                switch (eventID) {
                    case 503: 
                    case 506: {
                        JViewport viewport = AutoScrollActivator.this.autoScrollProperties.scrollPane.getViewport();
                        ((AutoScrollActivator)AutoScrollActivator.this).autoScrollProperties.currentLocation = MouseInfo.getPointerInfo().getLocation();
                        SwingUtilities.convertPointFromScreen(((AutoScrollActivator)AutoScrollActivator.this).autoScrollProperties.currentLocation, viewport);
                        if (((AutoScrollActivator)AutoScrollActivator.this).autoScrollProperties.isDragMode || eventID != 506) break;
                        Dimension size = new Dimension(Math.abs(((AutoScrollActivator)AutoScrollActivator.this).autoScrollProperties.currentLocation.x - ((AutoScrollActivator)AutoScrollActivator.this).autoScrollProperties.startLocation.x), Math.abs(((AutoScrollActivator)AutoScrollActivator.this).autoScrollProperties.currentLocation.y - ((AutoScrollActivator)AutoScrollActivator.this).autoScrollProperties.startLocation.y));
                        ((AutoScrollActivator)AutoScrollActivator.this).autoScrollProperties.isDragMode = size.width > HV_IMAGE_ICON.getIconWidth() / 2 || size.height > HV_IMAGE_ICON.getIconHeight() / 2;
                        break;
                    }
                    case 501: 
                    case 507: {
                        AutoScrollActivator.this.deactivateAutoScroll();
                        break;
                    }
                    case 502: {
                        if (!((AutoScrollActivator)AutoScrollActivator.this).autoScrollProperties.isDragMode || ((MouseEvent)e).getButton() != 2) break;
                        AutoScrollActivator.this.deactivateAutoScroll();
                        break;
                    }
                    case 208: {
                        AutoScrollActivator.this.deactivateAutoScroll();
                    }
                }
            }
        };
        try {
            Toolkit.getDefaultToolkit().addAWTEventListener(this.autoScrollProperties.toolkitListener, 655408L);
        }
        catch (Exception ex) {
            this.deactivateAutoScroll();
        }
    }

    private ImageIcon getAutoScrollIcon() {
        ImageIcon icon = this.autoScrollProperties.scrollPane.getHorizontalScrollBar().isVisible() ? (this.autoScrollProperties.scrollPane.getVerticalScrollBar().isVisible() ? HV_IMAGE_ICON : H_IMAGE_ICON) : (this.autoScrollProperties.scrollPane.getVerticalScrollBar().isVisible() ? V_IMAGE_ICON : HV_IMAGE_ICON);
        return icon;
    }

    public static void setAutoScrollEnabled(JComponent component, boolean isEnabled) {
        for (MouseListener mouseListener : component.getMouseListeners()) {
            if (!(mouseListener instanceof AutoScrollMouseListener)) continue;
            if (isEnabled) {
                return;
            }
            component.removeMouseListener(mouseListener);
            return;
        }
        if (isEnabled) {
            component.addMouseListener(autoScrollMouseListener);
        }
    }

    private static class AutoScrollMouseListener
    extends MouseAdapter {
        private AutoScrollMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.getButton() != 2) {
                return;
            }
            new AutoScrollActivator().activateAutoScroll(e);
        }
    }

    private static class AutoScrollProperties {
        public Point startLocation;
        public Point currentLocation;
        public Timer timer;
        public AWTEventListener toolkitListener;
        public boolean isDragMode;
        public JPopupMenu iconPopupMenu;
        private JScrollPane scrollPane;

        private AutoScrollProperties() {
        }
    }
}

