/*
 * Decompiled with CFR 0.152.
 */
package net.nextencia.dj.swingsuite;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.LookAndFeel;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.UIManager;
import javax.swing.plaf.MenuItemUI;

public class JJumpListMenuItem
extends JMenuItem {
    private int arrowWidth;
    private int arrowSpaceWidth;
    private boolean isArrowMouseOver;
    private boolean isMenuIndicationAlwaysVisible = true;
    private boolean isModernWindowsLaF;
    private JMenu jumpListMenu;

    public JJumpListMenuItem() {
        this.init();
    }

    public JJumpListMenuItem(String text) {
        super(text);
        this.init();
    }

    public JJumpListMenuItem(String text, int mnemonic) {
        super(text, mnemonic);
        this.init();
    }

    public JJumpListMenuItem(String text, Icon icon) {
        super(text, icon);
        this.init();
    }

    public JJumpListMenuItem(Action action) {
        super(action);
        this.init();
    }

    public JJumpListMenuItem(Icon icon) {
        super(icon);
        this.init();
    }

    private void init() {
        this.enableEvents(48L);
        this.arrowWidth = this.getPreferredSize().height / 4;
        this.arrowWidth -= (this.arrowWidth + 1) % 2;
        this.arrowSpaceWidth = this.arrowWidth + 4;
        this.setLayout(new FlowLayout(0, 0, 0));
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        switch (e.getID()) {
            case 500: 
            case 501: 
            case 502: {
                if (!this.isArrowMouseOver) break;
                e.consume();
                return;
            }
        }
        if (e.getID() != 502) {
            this.adjustPopupVisibility(e);
        }
        super.processMouseEvent(e);
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent e) {
        this.adjustPopupVisibility(e);
        super.processMouseMotionEvent(e);
    }

    private void adjustPopupVisibility(MouseEvent e) {
        if (this.jumpListMenu == null || !this.isEnabled()) {
            return;
        }
        boolean isShowing = this.jumpListMenu.getPopupMenu().isShowing();
        boolean oldIsArrowMouseOver = this.isArrowMouseOver;
        this.isArrowMouseOver = this.isArrowMouseOver(e);
        if (oldIsArrowMouseOver != this.isArrowMouseOver) {
            this.repaint();
        }
        if (this.isArrowMouseOver) {
            MenuSelectionManager defaultManager = MenuSelectionManager.defaultManager();
            MenuElement[] path = defaultManager.getSelectedPath();
            if (path.length > 0 && path[path.length - 1] == this) {
                MenuElement[] newPath = new MenuElement[path.length + 2];
                System.arraycopy(path, 0, newPath, 0, path.length);
                newPath[path.length] = this.jumpListMenu;
                newPath[path.length + 1] = this.jumpListMenu.getPopupMenu();
                MenuSelectionManager.defaultManager().setSelectedPath(newPath);
            }
            if (isShowing) {
                return;
            }
            Point popupMenuOrigin = this.getPopupMenuOrigin();
            this.jumpListMenu.getPopupMenu().show(this.jumpListMenu, popupMenuOrigin.x, popupMenuOrigin.y);
        } else if (isShowing) {
            this.jumpListMenu.getPopupMenu().setVisible(false);
        }
    }

    private boolean isArrowMouseOver(MouseEvent e) {
        if (this.jumpListMenu == null) {
            return false;
        }
        boolean isArrowMouseOver = false;
        if (this.getComponentOrientation().isLeftToRight()) {
            int right = this.getBorder().getBorderInsets((Component)e.getComponent()).right + this.arrowWidth + this.arrowSpaceWidth;
            isArrowMouseOver = e.getX() > this.getWidth() - right;
        } else {
            int left = this.getBorder().getBorderInsets((Component)e.getComponent()).left + this.arrowWidth + this.arrowSpaceWidth;
            isArrowMouseOver = e.getX() < left;
        }
        return isArrowMouseOver;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension preferredSize = super.getPreferredSize();
        if (this.jumpListMenu != null && !this.isPreferredSizeSet()) {
            preferredSize.width += this.arrowSpaceWidth;
        }
        return preferredSize;
    }

    public void setMenuIndicationAlwaysVisible(boolean isMenuIndicationAlwaysVisible) {
        this.isMenuIndicationAlwaysVisible = isMenuIndicationAlwaysVisible;
    }

    public boolean isMenuIndicationAlwaysVisible() {
        return this.isMenuIndicationAlwaysVisible;
    }

    @Override
    public void setUI(MenuItemUI ui) {
        LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
        this.isModernWindowsLaF = lookAndFeel.isNativeLookAndFeel() && System.getProperty("os.name").startsWith("Windows") && !Boolean.parseBoolean(System.getProperty("swing.noxp")) && !lookAndFeel.getClass().getName().endsWith("WindowsClassicLookAndFeel");
        super.setUI(ui);
    }

    @Override
    protected void paintComponent(Graphics g) {
        int x;
        super.paintComponent(g);
        boolean isArmed = this.isArmed();
        if (this.jumpListMenu == null || !this.isMenuIndicationAlwaysVisible && !isArmed) {
            return;
        }
        boolean isEnabled = this.isEnabled();
        int w = this.getWidth();
        int h = this.getHeight();
        int size = (this.arrowWidth + 1) / 2;
        Insets borderInsets = this.getBorder().getBorderInsets(this);
        int y = h / 2;
        boolean isLeftToRight = this.getComponentOrientation().isLeftToRight();
        Color foregroundColor = null;
        if (isArmed && !this.isModernWindowsLaF) {
            foregroundColor = UIManager.getColor("Menu.selectionForeground");
        }
        if (foregroundColor == null) {
            foregroundColor = this.getForeground();
        }
        if (isLeftToRight) {
            x = w - borderInsets.right - this.arrowWidth - this.arrowSpaceWidth;
            this.paintTriangle(g, x + this.arrowSpaceWidth / 2 + 1, y, size, isEnabled, isLeftToRight, foregroundColor);
        } else {
            x = borderInsets.left + this.arrowWidth + this.arrowSpaceWidth - 1;
            this.paintTriangle(g, x - this.arrowSpaceWidth / 2 - 1, y, size, isEnabled, isLeftToRight, foregroundColor);
        }
        if (!isArmed) {
            return;
        }
        int y1 = borderInsets.top;
        int y2 = h - borderInsets.bottom;
        int gradientHeight = Math.max((y2 - y1 + 1) / 5, 1);
        float gradientIncrement = (isEnabled ? 100.0f : 50.0f) / (float)gradientHeight;
        for (int i = 0; i < gradientHeight; ++i) {
            g.setColor(new Color(foregroundColor.getRed(), foregroundColor.getGreen(), foregroundColor.getBlue(), (int)(gradientIncrement * (float)(i + 1))));
            g.drawLine(x, y1 + i, x, y1 + i);
            g.drawLine(x, y2 - i, x, y2 - i);
        }
        Color dividerColor = new Color(foregroundColor.getRed(), foregroundColor.getGreen(), foregroundColor.getBlue(), isEnabled ? 100 : 50);
        g.setColor(dividerColor);
        g.drawLine(x, y1 + gradientHeight, x, y2 - gradientHeight);
    }

    private void paintTriangle(Graphics g, int x, int y, int size, boolean isEnabled, boolean isLeftToRight, Color foregroundColor) {
        Color oldColor = g.getColor();
        size = Math.max(size, 2);
        int mid = size / 2 - 1;
        g.translate(x, y);
        if (isEnabled) {
            g.setColor(foregroundColor);
        } else if (!isEnabled) {
            g.setColor(new Color(foregroundColor.getRed(), foregroundColor.getGreen(), foregroundColor.getBlue(), 100));
        }
        int j = 0;
        for (int i = size - 1; i >= 0; --i) {
            g.drawLine(j, mid - i, j, mid + i);
            if (isLeftToRight) {
                ++j;
                continue;
            }
            --j;
        }
        g.translate(-x, -y);
        g.setColor(oldColor);
    }

    public void setJumpListMenu(JMenu jumpListMenu) {
        if (this.jumpListMenu != null) {
            this.remove(this.jumpListMenu);
        }
        this.jumpListMenu = jumpListMenu;
        jumpListMenu.setBorder(BorderFactory.createEmptyBorder());
        jumpListMenu.setPreferredSize(new Dimension(0, 0));
        this.add(jumpListMenu);
    }

    public JMenu getJumpListMenu() {
        return this.jumpListMenu;
    }

    private Point getPopupMenuOrigin() {
        int y;
        int x;
        Rectangle screenBounds;
        JPopupMenu popupMenu = this.jumpListMenu.getPopupMenu();
        Point locationOnScreen = this.getLocationOnScreen();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        GraphicsConfiguration gc = this.getGraphicsConfiguration();
        for (GraphicsDevice gd : GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()) {
            GraphicsConfiguration dgc;
            if (gd.getType() != 0 || !(dgc = gd.getDefaultConfiguration()).getBounds().contains(locationOnScreen)) continue;
            gc = dgc;
            break;
        }
        if (gc == null) {
            screenBounds = new Rectangle(toolkit.getScreenSize());
        } else {
            screenBounds = gc.getBounds();
            Insets screenInsets = toolkit.getScreenInsets(gc);
            screenBounds.width -= Math.abs(screenInsets.left + screenInsets.right);
            screenBounds.height -= Math.abs(screenInsets.top + screenInsets.bottom);
            locationOnScreen.x -= Math.abs(screenInsets.left);
            locationOnScreen.y -= Math.abs(screenInsets.top);
        }
        int width = this.getWidth();
        int height = this.getHeight();
        Dimension popupMenuSize = popupMenu.getSize();
        if (popupMenuSize.width == 0) {
            popupMenuSize = popupMenu.getPreferredSize();
        }
        int xOffset = UIManager.getInt("Menu.submenuPopupOffsetX");
        int yOffset = UIManager.getInt("Menu.submenuPopupOffsetY");
        if (this.getComponentOrientation().isLeftToRight()) {
            x = width + xOffset;
            if (locationOnScreen.x + x + popupMenuSize.width >= screenBounds.width + screenBounds.x && screenBounds.width - width < 2 * (locationOnScreen.x - screenBounds.x)) {
                x = 0 - xOffset - popupMenuSize.width;
            }
        } else {
            x = 0 - xOffset - popupMenuSize.width;
            if (locationOnScreen.x + x < screenBounds.x && screenBounds.width - width > 2 * (locationOnScreen.x - screenBounds.x)) {
                x = width + xOffset;
            }
        }
        if (locationOnScreen.y + (y = yOffset) + popupMenuSize.height >= screenBounds.height + screenBounds.y && screenBounds.height - height < 2 * (locationOnScreen.y - screenBounds.y)) {
            y = height - yOffset - popupMenuSize.height;
        }
        return new Point(x, y);
    }
}

