/*
 * Decompiled with CFR 0.152.
 */
package net.nextencia.dj.swingsuite;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormatSymbols;
import java.util.Arrays;
import java.util.Locale;
import net.nextencia.dj.swingsuite.JTextEntryField;
import net.nextencia.dj.swingsuite.SwingSuiteUtilities;
import net.nextencia.dj.swingsuite.TextEntryValidator;

public class JNumberEntryField<T extends Number>
extends JTextEntryField {
    private boolean isNullAllowed;
    private T rangeMin;
    private T rangeMax;
    private NumberEntryFieldType numberEntryFieldType;
    private int decimalCount = -1;
    private static final char DECIMAL_SEPARATOR;

    private T getNumber(String text) {
        T number = this.parseNumber(text);
        if (number == null) {
            return null;
        }
        if (!this.isRangeValid(number)) {
            return null;
        }
        if (!this.isDecimalCountValid(text)) {
            return null;
        }
        return number;
    }

    private T parseNumber(String text) {
        return (T)this.numberEntryFieldType.parseNumber(text.replace(DECIMAL_SEPARATOR, '.'));
    }

    @Override
    public void replaceSelection(String content) {
        if (content != null) {
            content = content.trim();
        }
        super.replaceSelection(content);
    }

    private boolean isRangeValid(T number) {
        return !(this.rangeMin != null && ((Comparable)number).compareTo(this.rangeMin) < 0 || this.rangeMax != null && ((Comparable)number).compareTo(this.rangeMax) > 0);
    }

    private boolean isDecimalCountValid(String text) {
        if (this.decimalCount >= 0) {
            int separatorPosition = text.indexOf(DECIMAL_SEPARATOR);
            if (separatorPosition < 0) {
                separatorPosition = text.indexOf(46);
            }
            if (separatorPosition >= 0 && text.length() - separatorPosition - 1 > this.decimalCount) {
                return false;
            }
        }
        return true;
    }

    public JNumberEntryField(T number) {
        this(number, 0);
    }

    public JNumberEntryField(T number, T rangeMin, T rangeMax) {
        this(number, rangeMin, rangeMax, false);
    }

    public JNumberEntryField(T number, T rangeMin, T rangeMax, boolean isNullAllowed) {
        this(number, 0, rangeMin, rangeMax, isNullAllowed);
    }

    public JNumberEntryField(T number, int columns) {
        this(number, columns, -1);
    }

    public JNumberEntryField(T number, int columns, int decimalCount) {
        this(number, columns, decimalCount, null, null);
    }

    public JNumberEntryField(T number, int columns, T rangeMin, T rangeMax) {
        this(number, columns, rangeMin, rangeMax, false);
    }

    public JNumberEntryField(T number, int columns, T rangeMin, T rangeMax, boolean isNullAllowed) {
        this(number, columns, -1, rangeMin, rangeMax, isNullAllowed);
    }

    public JNumberEntryField(T number, int columns, int decimalCount, T rangeMin, T rangeMax) {
        this(number, columns, decimalCount, rangeMin, rangeMax, false);
    }

    public JNumberEntryField(T number, int columns, int decimalCount, T rangeMin, T rangeMax, boolean isNullAllowed) {
        super(columns);
        this.setHorizontalAlignment(11);
        this.setFieldType(number);
        this.setText("0");
        this.setValidator(null);
        this.setDecimalCount(decimalCount);
        this.setRange(rangeMin, rangeMax);
        this.setNullAllowed(isNullAllowed);
        this.setNumber(number);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                this.processKey(e);
            }

            @Override
            public void keyReleased(KeyEvent e) {
                this.processKey(e);
            }

            @Override
            public void keyTyped(KeyEvent e) {
                this.processKey(e);
            }

            private void processKey(KeyEvent e) {
                if (!JNumberEntryField.this.isEditable() || !JNumberEntryField.this.isEnabled()) {
                    return;
                }
                Integer factor = null;
                boolean isDivision = false;
                switch (e.getKeyChar()) {
                    case 'k': {
                        factor = 1000;
                        break;
                    }
                    case 'K': {
                        factor = 1000;
                        isDivision = true;
                        break;
                    }
                    case 'm': {
                        factor = 1000000;
                        break;
                    }
                    case 'M': {
                        factor = 1000000;
                        isDivision = true;
                    }
                }
                if (factor != null) {
                    double d;
                    Number number;
                    if (e.getID() == 401 && (number = JNumberEntryField.this.parseNumber(JNumberEntryField.this.getText())) != null && !Double.isInfinite(d = number.doubleValue()) && !Double.isNaN(d)) {
                        d = isDivision ? (d /= (double)factor.intValue()) : (d *= (double)factor.intValue());
                        String formattedNumber = JNumberEntryField.this.numberEntryFieldType.formatNumber(d);
                        JNumberEntryField.this.setText(formattedNumber);
                    }
                    e.consume();
                    JNumberEntryField.this.setCaretPosition(JNumberEntryField.this.getText().length());
                }
            }
        });
    }

    @Override
    public void setValidator(TextEntryValidator validator) {
        if (validator == null) {
            validator = new NumberEntryFieldValueValidator();
        }
        super.setValidator(validator);
    }

    private void setFieldType(T number) {
        if (number == null) {
            throw new IllegalArgumentException("The number cannot be null!");
        }
        for (NumberEntryFieldType type : NumberEntryFieldType.values()) {
            Class<?> numberClass = number.getClass();
            if (!type.getNumberClass().isAssignableFrom(numberClass)) continue;
            this.numberEntryFieldType = type;
            return;
        }
        throw new IllegalArgumentException("The type \"" + number.getClass().getName() + "\" is not supported! It must be one of " + Arrays.asList(NumberEntryFieldType.values()));
    }

    public void setRange(T rangeMin, T rangeMax) {
        this.rangeMin = rangeMin == null ? this.numberEntryFieldType.getRangeMin() : rangeMin;
        Object object = this.rangeMax = rangeMin == null ? this.numberEntryFieldType.getRangeMax() : rangeMax;
        if (rangeMin != null && rangeMax != null && ((Comparable)this.rangeMin).compareTo(this.rangeMax) > 0) {
            throw new IllegalArgumentException("Maximum range value must be greater than minimum value.");
        }
        this.revalidateText();
    }

    public void setNullAllowed(boolean isNullAllowed) {
        this.isNullAllowed = isNullAllowed;
        this.revalidateText();
    }

    public boolean isNullAllowed() {
        return this.isNullAllowed;
    }

    public void setDecimalCount(int decimalCount) {
        this.decimalCount = decimalCount;
        this.revalidateText();
    }

    public int getDecimalCount() {
        return this.decimalCount;
    }

    public T getNumber() {
        return this.getNumber(this.getValidText());
    }

    public void setNumber(T number) {
        if (this.isNullAllowed && number == null) {
            this.setText("");
        } else {
            this.setText(this.numberEntryFieldType.formatNumber((Number)number));
        }
    }

    static {
        String s = System.getProperty("swingsuite.decimalSeparator");
        DECIMAL_SEPARATOR = s != null && s.length() == 1 ? s.charAt(0) : new DecimalFormatSymbols(Locale.getDefault()).getDecimalSeparator();
    }

    private static enum NumberEntryFieldType {
        BYTE(Byte.class, false, (byte)-128, (byte)127),
        SHORT(Short.class, false, (short)Short.MIN_VALUE, (short)Short.MAX_VALUE),
        INTEGER(Integer.class, false, Integer.MIN_VALUE, Integer.MAX_VALUE),
        BIG_INTEGER(BigInteger.class, false, null, null),
        LONG(Long.class, false, Long.MIN_VALUE, Long.MAX_VALUE),
        FLOAT(Float.class, true, null, null),
        DOUBLE(Double.class, true, null, null),
        BIG_DECIMAL(BigDecimal.class, true, null, null);

        private Class<? extends Number> numberClass;
        private boolean hasDecimals;
        private Number rangeMin;
        private Number rangeMax;

        private <T extends Number> NumberEntryFieldType(Class<T> numberClass, boolean hasDecimals, T rangeMin, T rangeMax) {
            this.numberClass = numberClass;
            this.hasDecimals = hasDecimals;
            this.rangeMin = rangeMin;
            this.rangeMax = rangeMax;
        }

        public Class<? extends Number> getNumberClass() {
            return this.numberClass;
        }

        public boolean hasDecimals() {
            return this.hasDecimals;
        }

        public Number getRangeMin() {
            return this.rangeMin;
        }

        public Number getRangeMax() {
            return this.rangeMax;
        }

        public String toString() {
            return this.numberClass.getName();
        }

        public Number parseNumber(String text) {
            if (text == null || "".equals(text)) {
                return null;
            }
            try {
                switch (this) {
                    case BYTE: {
                        return Byte.valueOf(text);
                    }
                    case SHORT: {
                        return Short.valueOf(text);
                    }
                    case INTEGER: {
                        return Integer.valueOf(text);
                    }
                    case BIG_INTEGER: {
                        return new BigInteger(text);
                    }
                    case LONG: {
                        return Long.valueOf(text);
                    }
                    case FLOAT: {
                        return Float.valueOf(text);
                    }
                    case DOUBLE: {
                        return Double.valueOf(text);
                    }
                    case BIG_DECIMAL: {
                        return new BigDecimal(text);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }

        public String formatNumber(Number number) {
            int index;
            String s = number.toString();
            boolean isNegative = s.startsWith("-");
            if (isNegative) {
                s = s.substring(1);
            }
            if ((index = s.indexOf(69)) >= 0) {
                int exponent = Integer.parseInt(s.substring(index + 1));
                String root = s.substring(0, 1) + s.substring(2, index);
                if (exponent >= 0) {
                    int length = root.length();
                    if (exponent < length - 1) {
                        s = root.substring(0, exponent + 1) + '.' + root.substring(exponent + 1);
                    } else if (exponent >= length) {
                        char[] zeros = new char[exponent + 1 - length];
                        Arrays.fill(zeros, '0');
                        s = root + new String(zeros);
                    } else {
                        s = root;
                    }
                } else {
                    char[] zeros = new char[-exponent - 1];
                    Arrays.fill(zeros, '0');
                    s = "0." + new String(zeros) + root;
                    if (s.endsWith("0")) {
                        s = s.substring(0, s.length() - 1);
                    }
                }
            }
            if (s.endsWith(".0")) {
                s = s.substring(0, s.length() - 2);
            }
            String value = s.replace('.', DECIMAL_SEPARATOR);
            if (isNegative) {
                value = "-" + value;
            }
            return value;
        }
    }

    private class NumberEntryFieldValueValidator
    extends TextEntryValidator {
        private NumberEntryFieldValueValidator() {
        }

        @Override
        public boolean isTextAllowed(JTextEntryField validationField, String text) {
            if (JNumberEntryField.this.isNullAllowed && (text == null || "".equals(text))) {
                return true;
            }
            for (int i = text.length() - 1; i >= 0; --i) {
                int codePoint = text.codePointAt(i);
                if ((codePoint == DECIMAL_SEPARATOR || codePoint == 46) && JNumberEntryField.this.numberEntryFieldType.hasDecimals() || Character.isDigit(codePoint) || codePoint == 45 && i <= 0) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean isTextValid(JTextEntryField validationField, String text) {
            if (JNumberEntryField.this.isNullAllowed && (text == null || "".equals(text))) {
                return true;
            }
            return JNumberEntryField.this.getNumber(text) != null;
        }

        @Override
        public String getInvalidTextErrorMessage(JTextEntryField validationField, String invalidText) {
            if (JNumberEntryField.this.isNullAllowed && (invalidText == null || "".equals(invalidText))) {
                return null;
            }
            Number number = JNumberEntryField.this.parseNumber(invalidText);
            if (number == null) {
                int decimalCount = 0;
                int length = invalidText.length();
                boolean isInvalid = length == 0;
                boolean hasDigit = false;
                for (int i = 0; i < length; ++i) {
                    char c = invalidText.charAt(i);
                    if (Character.isDigit(c)) {
                        hasDigit = true;
                        continue;
                    }
                    if (c == '-' && i == 0 && length != 1) continue;
                    if (c != DECIMAL_SEPARATOR && c != '.') {
                        isInvalid = true;
                        break;
                    }
                    if (JNumberEntryField.this.numberEntryFieldType.hasDecimals() && ++decimalCount <= 1) continue;
                    isInvalid = true;
                    break;
                }
                if (isInvalid || !hasDigit) {
                    return SwingSuiteUtilities.getUIManagerMessage("NumberEntryField.invalidFormatMessage", "Invalid format", new Object[0]);
                }
            } else if (!JNumberEntryField.this.isDecimalCountValid(invalidText)) {
                return SwingSuiteUtilities.getUIManagerMessage("NumberEntryField.maxDecimalsMessage", "Max decimals: {0}", JNumberEntryField.this.decimalCount);
            }
            return SwingSuiteUtilities.getUIManagerMessage("NumberEntryField.rangeMessage", "Range: {0} .. {1}", JNumberEntryField.this.rangeMin == null ? "-\u221e" : JNumberEntryField.this.rangeMin, JNumberEntryField.this.rangeMax == null ? "+\u221e" : JNumberEntryField.this.rangeMax);
        }

        @Override
        public String getDefaultValidText(JTextEntryField validationField) {
            Number zero = JNumberEntryField.this.parseNumber("0");
            String s = !(JNumberEntryField.this.rangeMin != null && ((Comparable)((Object)JNumberEntryField.this.rangeMin)).compareTo(zero) > 0 || JNumberEntryField.this.rangeMax != null && ((Comparable)((Object)JNumberEntryField.this.rangeMax)).compareTo(zero) < 0) ? "0" : (JNumberEntryField.this.rangeMin != null && ((Comparable)((Object)JNumberEntryField.this.rangeMin)).compareTo(zero) > 0 ? JNumberEntryField.this.rangeMin.toString() : JNumberEntryField.this.rangeMax.toString());
            return s.replace('.', DECIMAL_SEPARATOR);
        }
    }
}

