/*
 * Decompiled with CFR 0.152.
 */
package net.nextencia.dj.swingsuite;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.lang.reflect.Method;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ButtonUI;
import javax.swing.plaf.basic.BasicRadioButtonUI;
import javax.swing.plaf.synth.SynthContext;
import net.nextencia.dj.swingsuite.TriStateCheckBoxListener;

public class JTriStateCheckBox
extends JCheckBox {
    private TriStateModel model;
    private boolean isUIAdjustement;
    private static Color indeterminateColor;
    private static Color indeterminateDisabledColor;
    private String lafClassName;
    private int gap;

    public JTriStateCheckBox() {
        this.init();
    }

    public JTriStateCheckBox(Action a) {
        super(a);
        this.init();
    }

    public JTriStateCheckBox(Icon icon) {
        super(icon);
        this.init();
    }

    public JTriStateCheckBox(Icon icon, boolean selected) {
        super(icon, selected);
        this.init();
    }

    public JTriStateCheckBox(String text) {
        super(text);
        this.init();
    }

    public JTriStateCheckBox(String text, boolean selected) {
        super(text, selected);
        this.init();
    }

    public JTriStateCheckBox(String text, Icon icon) {
        super(text, icon);
        this.init();
    }

    public JTriStateCheckBox(String text, Icon icon, boolean selected) {
        super(text, icon, selected);
        this.init();
    }

    private void init() {
        this.model = new TriStateModel();
        this.setModel(this.model);
        ActionMapUIResource map = new ActionMapUIResource();
        map.put("pressed", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JTriStateCheckBox.this.grabFocus();
                JTriStateCheckBox.this.isUIAdjustement = true;
                JTriStateCheckBox.this.model.nextState();
                JTriStateCheckBox.this.isUIAdjustement = false;
                JTriStateCheckBox.this.repaint();
            }
        });
        map.put("released", null);
        SwingUtilities.replaceUIActionMap(this, map);
    }

    @Override
    public void setSelected(boolean isSelected) {
        this.setState(isSelected ? CheckState.SELECTED : CheckState.NOT_SELECTED);
    }

    public void setState(CheckState state) {
        this.isUIAdjustement = true;
        this.model.setState(state);
        this.isUIAdjustement = false;
        this.model.adjustRollingState(state);
    }

    public CheckState getState() {
        return this.model.getState();
    }

    @Override
    public void updateUI() {
        ButtonUI ui;
        Icon icon;
        super.updateUI();
        String currentLafClassName = UIManager.getLookAndFeel().getClass().getName();
        if (indeterminateColor == null || !currentLafClassName.equals(this.lafClassName)) {
            this.lafClassName = currentLafClassName;
            JCheckBox checkBox = new JCheckBox();
            indeterminateColor = this.findIndeterminateColor(checkBox);
            checkBox.setEnabled(false);
            indeterminateDisabledColor = this.findIndeterminateColor(checkBox);
        }
        if ((icon = (ui = this.getUI()) instanceof BasicRadioButtonUI ? ((BasicRadioButtonUI)ui).getDefaultIcon() : UIManager.getIcon("CheckBox.icon")) instanceof IndeterminateIcon) {
            return;
        }
        this.gap = Math.round((float)icon.getIconWidth() / 4.0f);
        this.setIcon(new IndeterminateIcon(icon));
    }

    private Color findIndeterminateColor(JCheckBox checkBox) {
        checkBox.setSelected(false);
        checkBox.setSize(checkBox.getPreferredSize());
        int imgWidth = checkBox.getWidth() - 4;
        int imgHeight = checkBox.getHeight() - 4;
        BufferedImage img1 = new BufferedImage(imgWidth, imgHeight, 2);
        Graphics graphics = img1.getGraphics();
        graphics.translate(-2, -2);
        checkBox.print(graphics);
        graphics.dispose();
        checkBox.setSelected(true);
        BufferedImage img2 = new BufferedImage(imgWidth, imgHeight, 2);
        graphics = img2.getGraphics();
        graphics.translate(-2, -2);
        checkBox.print(graphics);
        graphics.dispose();
        int diff = 0;
        int rgb = 0;
        for (int i = 0; i < imgWidth; ++i) {
            for (int j = 0; j < imgHeight; ++j) {
                int rgb2;
                int rgb1 = img1.getRGB(i, j);
                int rDiff = Math.abs(rgb1 & 255 - (rgb2 = img2.getRGB(i, j)) & 0xFF) + Math.abs(rgb1 >> 8 & 255 - rgb2 >> 8 & 0xFF) + Math.abs(rgb1 >> 16 & 255 - rgb2 >> 16 & 0xFF);
                if (rDiff <= diff) continue;
                diff = rDiff;
                rgb = rgb2;
            }
        }
        return new Color(rgb);
    }

    public void setRollingStates(CheckState ... states) {
        this.model.setRollingStates(states);
    }

    public void addTriStateCheckBoxListener(TriStateCheckBoxListener listener) {
        this.listenerList.add(TriStateCheckBoxListener.class, listener);
    }

    public void removeTriStateCheckBoxListener(TriStateCheckBoxListener listener) {
        this.listenerList.remove(TriStateCheckBoxListener.class, listener);
    }

    public TriStateCheckBoxListener[] getTriStateCheckBoxListeners() {
        return (TriStateCheckBoxListener[])this.listenerList.getListeners(TriStateCheckBoxListener.class);
    }

    private static class IndeterminateIcon
    implements Icon {
        private Icon icon;
        private static Method getContextMethod;
        private static Method paintIconMethod;
        private BufferedImage image;

        public IndeterminateIcon(Icon icon) {
            this.icon = icon;
        }

        @Override
        public int getIconWidth() {
            return this.icon.getIconWidth();
        }

        @Override
        public int getIconHeight() {
            return this.icon.getIconHeight();
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            JTriStateCheckBox checkBox = (JTriStateCheckBox)c;
            boolean isSynthPainted = false;
            int width = this.icon.getIconWidth();
            int height = this.icon.getIconHeight();
            Color indeterminateColor_ = c.isEnabled() ? indeterminateColor : indeterminateDisabledColor;
            try {
                Class<?> synthIconClass = Class.forName("sun.swing.plaf.synth.SynthIcon");
                if (synthIconClass.isAssignableFrom(this.icon.getClass())) {
                    ButtonUI ui = checkBox.getUI();
                    if (paintIconMethod == null) {
                        getContextMethod = ui.getClass().getMethod("getContext", JComponent.class);
                        getContextMethod.setAccessible(true);
                        paintIconMethod = synthIconClass.getMethod("paintIcon", SynthContext.class, Graphics.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
                        paintIconMethod.setAccessible(true);
                    }
                    SynthContext context = (SynthContext)getContextMethod.invoke((Object)ui, checkBox);
                    if (checkBox.getState() == CheckState.INDETERMINATE) {
                        if (this.image == null) {
                            this.image = new BufferedImage(width, height, 2);
                        }
                        Graphics2D g2d = (Graphics2D)this.image.getGraphics();
                        g2d.setComposite(AlphaComposite.Clear);
                        g2d.fillRect(0, 0, width, height);
                        g2d.setComposite(AlphaComposite.Src);
                        paintIconMethod.invoke((Object)this.icon, context, g2d, 0, 0, this.getIconWidth(), this.getIconHeight());
                        g2d.setComposite(AlphaComposite.SrcAtop);
                        for (int i = 0; i < width; ++i) {
                            for (int j = 0; j < height; ++j) {
                                int alpha = (this.image.getRGB(i, j) >> 24 & 0xFF) / 2;
                                g2d.setColor(new Color(indeterminateColor_.getRed(), indeterminateColor_.getGreen(), indeterminateColor_.getBlue(), alpha));
                                g2d.drawLine(i, j, i, j);
                            }
                        }
                        g2d.dispose();
                        g.translate(x, y);
                        g.drawImage(this.image, 0, 0, c);
                        g.translate(-x, -y);
                    } else {
                        paintIconMethod.invoke((Object)this.icon, context, g, x, y, this.getIconWidth(), this.getIconHeight());
                    }
                    isSynthPainted = true;
                }
            }
            catch (Exception synthIconClass) {
                // empty catch block
            }
            if (!isSynthPainted) {
                this.icon.paintIcon(c, g, x, y);
            }
            if (!isSynthPainted && checkBox.getState() == CheckState.INDETERMINATE) {
                g.setColor(indeterminateColor_);
                int gap = checkBox.gap;
                g.fillRect(x + gap, y + gap, width - 2 * gap, height - 2 * gap);
            }
        }
    }

    private class TriStateModel
    extends JToggleButton.ToggleButtonModel {
        private boolean isIndeterminate;
        private CheckState[] rollingStates = new CheckState[]{CheckState.NOT_SELECTED, CheckState.SELECTED, CheckState.INDETERMINATE};
        private int rollingIndex;

        private TriStateModel() {
        }

        private void setIndeterminate(boolean isIndeterminate) {
            this.isIndeterminate = isIndeterminate;
        }

        private void setState(CheckState state) {
            if (this.getState() == state) {
                return;
            }
            if (state == CheckState.NOT_SELECTED) {
                this.setIndeterminate(false);
                this.setSelected(false);
            } else if (state == CheckState.SELECTED) {
                this.setIndeterminate(false);
                this.setSelected(true);
            } else {
                this.setIndeterminate(true);
                this.setSelected(false);
            }
            this.setArmed(false);
            JTriStateCheckBox.this.repaint();
            for (TriStateCheckBoxListener listener : JTriStateCheckBox.this.getTriStateCheckBoxListeners()) {
                listener.stateChanged(JTriStateCheckBox.this, state);
            }
        }

        private CheckState getState() {
            if (this.isIndeterminate) {
                return CheckState.INDETERMINATE;
            }
            if (this.isSelected()) {
                return CheckState.SELECTED;
            }
            return CheckState.NOT_SELECTED;
        }

        public void setRollingStates(CheckState ... states) {
            this.rollingStates = states;
            this.adjustRollingState(this.getState());
        }

        public void adjustRollingState(CheckState state) {
            this.rollingIndex = -1;
            for (int i = 0; i < this.rollingStates.length; ++i) {
                if (this.rollingStates[i] != state) continue;
                this.rollingIndex = i;
                break;
            }
        }

        private void nextState() {
            this.setState(this.rollingStates[++this.rollingIndex % this.rollingStates.length]);
        }

        @Override
        public void setEnabled(boolean b) {
            JTriStateCheckBox.this.setFocusable(b);
            super.setEnabled(b);
        }

        @Override
        public void setSelected(boolean b) {
            if (!JTriStateCheckBox.this.isUIAdjustement) {
                JTriStateCheckBox.this.isUIAdjustement = true;
                this.nextState();
                JTriStateCheckBox.this.isUIAdjustement = false;
                return;
            }
            super.setSelected(b);
        }
    }

    public static enum CheckState {
        SELECTED,
        NOT_SELECTED,
        INDETERMINATE;

    }
}

