/*
 * Decompiled with CFR 0.152.
 */
package net.nextencia.dj.swingsuite;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class LayeredIcon
extends ImageIcon {
    private List<Icon> iconList = new ArrayList<Icon>(3);
    private List<Point> iconLocationList = new ArrayList<Point>(3);
    private int width;
    private int height;
    private Component component;
    private ImageObserver observer;
    private Image currentImage;
    private HierarchyListener hierarchyListener = new HierarchyListener(){

        @Override
        public void hierarchyChanged(HierarchyEvent e) {
            if (!LayeredIcon.this.component.isDisplayable()) {
                LayeredIcon.this.setComponent(null);
            }
        }
    };

    public LayeredIcon(int width, int height) {
        this.width = width;
        this.height = height;
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }

    @Override
    public void paintIcon(Component component, Graphics g, int x, int y) {
        if (component != null) {
            this.setComponent(component);
        }
        for (int i = 0; i < this.iconList.size(); ++i) {
            Point location = this.iconLocationList.get(i);
            this.iconList.get(i).paintIcon(component, g, x + location.x, y + location.y);
        }
    }

    public Icon[] getIcons() {
        return this.iconList.toArray(new Icon[0]);
    }

    public Point[] getIconLocations() {
        return this.iconLocationList.toArray(new Point[0]);
    }

    public int getIconCount() {
        return this.iconList.size();
    }

    public void removeIcon(Icon icon) {
        int index = this.iconList.indexOf(icon);
        if (index >= 0) {
            this.iconList.remove(index);
            this.iconLocationList.remove(index);
        }
    }

    public void removeAllIcons() {
        this.iconList.clear();
        this.iconLocationList.clear();
    }

    public void addIcon(Icon icon) {
        this.addIcon(icon, new Point(0, 0));
    }

    public void addIcon(Icon icon, int x, int y) {
        this.addIcon(icon, new Point(x, y));
    }

    public void addIcon(Icon icon, Point location) {
        this.addIcon(icon, location, this.getIconCount());
    }

    public void addIcon(Icon icon, Point location, int zOrder) {
        this.iconList.add(zOrder, icon);
        this.iconLocationList.add(zOrder, location);
        if (icon instanceof ImageIcon) {
            if (this.observer == null) {
                this.observer = new ImageObserver(){

                    @Override
                    public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
                        if (LayeredIcon.this.component != null) {
                            LayeredIcon.this.currentImage = img;
                            boolean result = LayeredIcon.this.component.imageUpdate(img, infoflags, x, y, width, height);
                            LayeredIcon.this.currentImage = null;
                            return result;
                        }
                        return false;
                    }
                };
            }
            ((ImageIcon)icon).setImageObserver(this.observer);
        }
    }

    @Override
    public Image getImage() {
        if (this.currentImage == null) {
            BufferedImage img = new BufferedImage(this.width, this.height, 2);
            this.paintIcon(this.component, img.getGraphics(), 0, 0);
            return img;
        }
        return this.currentImage;
    }

    public Component getComponent() {
        return this.component;
    }

    public void setComponent(Component component) {
        if (component == this.component) {
            return;
        }
        if (this.component != null) {
            this.component.removeHierarchyListener(this.hierarchyListener);
        }
        if (component != null) {
            component.addHierarchyListener(this.hierarchyListener);
        }
        this.component = component;
    }
}

