/*
 * Decompiled with CFR 0.152.
 */
package net.nextencia.dj.swingsuite;

import java.util.ArrayList;
import net.nextencia.dj.swingsuite.TextEntryMask;

public class PatternTextEntryMask
extends TextEntryMask {
    private CharType[] charTypes;
    private int[] chars;
    private int defaultChar;

    public PatternTextEntryMask(String pattern) {
        this(pattern, 95);
    }

    public PatternTextEntryMask(String pattern, int defaultChar) {
        int i;
        if (pattern == null || pattern.length() == 0) {
            throw new IllegalArgumentException("The mask cannot be empty!");
        }
        this.defaultChar = defaultChar;
        ArrayList<CharType> charTypeList = new ArrayList<CharType>();
        ArrayList<Integer> charList = new ArrayList<Integer>();
        boolean isLastQuote = false;
        int predefinedCount = 0;
        for (i = 0; i < pattern.length(); ++i) {
            int c = pattern.codePointAt(i);
            if (isLastQuote) {
                isLastQuote = false;
                charTypeList.add(CharType.PREDEFINED_CHAR);
                charList.add(c);
                ++predefinedCount;
                continue;
            }
            CharType type = null;
            switch (c) {
                case 35: {
                    type = CharType.DIGIT;
                    break;
                }
                case 85: {
                    type = CharType.LETTER_TO_UPPERCASE;
                    break;
                }
                case 76: {
                    type = CharType.LETTER_TO_LOWERCASE;
                    break;
                }
                case 65: {
                    type = CharType.LETTER_OR_DIGIT;
                    break;
                }
                case 72: {
                    type = CharType.HEX_CHAR;
                    break;
                }
                case 63: {
                    type = CharType.ANY_LETTER;
                    break;
                }
                case 42: {
                    type = CharType.ANY_CHAR;
                    break;
                }
                case 39: {
                    isLastQuote = true;
                    break;
                }
                default: {
                    charTypeList.add(CharType.PREDEFINED_CHAR);
                    charList.add(c);
                    ++predefinedCount;
                }
            }
            if (type == null) continue;
            charTypeList.add(type);
            charList.add(defaultChar);
        }
        if (predefinedCount == charList.size()) {
            throw new IllegalArgumentException("The mask \"" + pattern + "\" must contain some editable characters!");
        }
        if (isLastQuote) {
            throw new IllegalArgumentException("The mask \"" + pattern + "\" contains a dangling quote!");
        }
        this.charTypes = charTypeList.toArray(new CharType[0]);
        this.chars = new int[this.charTypes.length];
        for (i = 0; i < this.chars.length; ++i) {
            this.chars[i] = (Integer)charList.get(i);
        }
    }

    @Override
    protected int getDefaultCodePoint(int position) {
        return this.chars[position];
    }

    @Override
    protected Integer getCodePoint(String text, int codePoint, int position) {
        CharType charType = this.charTypes[position];
        if (codePoint == this.defaultChar && charType != CharType.PREDEFINED_CHAR) {
            return codePoint;
        }
        switch (this.charTypes[position]) {
            case DIGIT: {
                if (!Character.isDigit(codePoint)) {
                    return null;
                }
                return codePoint;
            }
            case LETTER_TO_UPPERCASE: {
                if (!Character.isLetter(codePoint)) {
                    return null;
                }
                return Character.toUpperCase(codePoint);
            }
            case LETTER_TO_LOWERCASE: {
                if (!Character.isLetter(codePoint)) {
                    return null;
                }
                return Character.toLowerCase(codePoint);
            }
            case LETTER_OR_DIGIT: {
                if (!Character.isLetter(codePoint) && !Character.isDigit(codePoint)) {
                    return null;
                }
                return codePoint;
            }
            case HEX_CHAR: {
                if (codePoint >= 48 && codePoint <= 57 || codePoint >= 97 && codePoint <= 102 || codePoint >= 65 && codePoint <= 70) {
                    return codePoint;
                }
                return null;
            }
            case ANY_LETTER: {
                if (!Character.isLetter(codePoint)) {
                    return null;
                }
                return codePoint;
            }
            case ANY_CHAR: {
                return codePoint;
            }
            case PREDEFINED_CHAR: {
                if (codePoint != this.chars[position]) {
                    return null;
                }
                return codePoint;
            }
        }
        return null;
    }

    @Override
    protected int getLength() {
        return this.chars.length;
    }

    @Override
    protected int getNextValidInputPosition(int position) {
        for (int i = position; i < this.charTypes.length; ++i) {
            if (this.charTypes[i] == CharType.PREDEFINED_CHAR) continue;
            return i;
        }
        return this.chars.length;
    }

    private static enum CharType {
        DIGIT,
        LETTER_TO_UPPERCASE,
        LETTER_TO_LOWERCASE,
        LETTER_OR_DIGIT,
        HEX_CHAR,
        ANY_LETTER,
        ANY_CHAR,
        PREDEFINED_CHAR;

    }
}

