/*
 * Decompiled with CFR 0.152.
 */
package net.objectlab.kit.datecalc.jdk8;

import java.time.DayOfWeek;
import java.time.LocalDate;
import net.objectlab.kit.datecalc.common.WorkingWeek;

public class Jdk8WorkingWeek
extends WorkingWeek {
    private static final int MAX_WEEKDAY_INDEX = 7;
    public static final Jdk8WorkingWeek DEFAULT = new Jdk8WorkingWeek();

    public Jdk8WorkingWeek() {
    }

    protected Jdk8WorkingWeek(byte workingDays) {
        super(workingDays);
    }

    public Jdk8WorkingWeek(WorkingWeek ww) {
        this(ww.getWorkingDays());
    }

    public boolean isWorkingDay(LocalDate date) {
        int dayOfWeek = Jdk8WorkingWeek.jdk8ToCalendarDayConstant(date.getDayOfWeek());
        return this.isWorkingDayFromCalendar(dayOfWeek);
    }

    public Jdk8WorkingWeek withWorkingDayFromDateTimeConstant(boolean working, DayOfWeek givenDayOfWeek) {
        int dayOfWeek = Jdk8WorkingWeek.jdk8ToCalendarDayConstant(givenDayOfWeek);
        return new Jdk8WorkingWeek(super.withWorkingDayFromCalendar(working, dayOfWeek));
    }

    public boolean isWorkingDayFromDateTimeConstant(DayOfWeek dayOfWeek) {
        return this.isWorkingDayFromCalendar(Jdk8WorkingWeek.jdk8ToCalendarDayConstant(dayOfWeek));
    }

    public static int jdk8ToCalendarDayConstant(DayOfWeek givenDayOfWeek) {
        int dayOfWeek = givenDayOfWeek.getValue() + 1;
        return dayOfWeek <= 7 ? dayOfWeek : dayOfWeek % 7;
    }
}

