/*
 * Decompiled with CFR 0.152.
 */
package net.objectlab.kit.datecalc.jdk8;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.Month;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.List;
import net.objectlab.kit.datecalc.common.AbstractIMMDateCalculator;
import net.objectlab.kit.datecalc.common.IMMPeriod;

public class LocalDateIMMDateCalculator
extends AbstractIMMDateCalculator<LocalDate> {
    @Override
    public List<LocalDate> getIMMDates(LocalDate start, LocalDate end, IMMPeriod period) {
        ArrayList<LocalDate> dates = new ArrayList<LocalDate>();
        LocalDate date = start;
        while (!(date = this.getNextIMMDate(true, date, period)).isAfter(end)) {
            dates.add(date);
        }
        return dates;
    }

    @Override
    protected LocalDate getNextIMMDate(boolean requestNextIMM, LocalDate start, IMMPeriod period) {
        LocalDate date = start;
        LocalDate imm = LocalDateIMMDateCalculator.calculate3rdWednesday(date = this.calculateIMMMonth(requestNextIMM, date, date.getMonth()));
        Month immMonth = imm.getMonth();
        boolean isMarchSept = immMonth == Month.MARCH || immMonth == Month.SEPTEMBER;
        switch (period) {
            case BI_ANNUALY_JUN_DEC: {
                if (!isMarchSept) break;
                imm = this.getNextIMMDate(requestNextIMM, imm, period);
                break;
            }
            case BI_ANNUALY_MAR_SEP: {
                if (isMarchSept) break;
                imm = this.getNextIMMDate(requestNextIMM, imm, period);
                break;
            }
            case ANNUALLY: {
                imm = this.getNextIMMDate(requestNextIMM, imm, IMMPeriod.QUARTERLY);
                imm = this.getNextIMMDate(requestNextIMM, imm, IMMPeriod.QUARTERLY);
                imm = this.getNextIMMDate(requestNextIMM, imm, IMMPeriod.QUARTERLY);
                imm = this.getNextIMMDate(requestNextIMM, imm, IMMPeriod.QUARTERLY);
                break;
            }
        }
        return imm;
    }

    private LocalDate calculateIMMMonth(boolean requestNextIMM, LocalDate startDate, Month month) {
        LocalDate date = startDate;
        switch (month) {
            case MARCH: 
            case JUNE: 
            case SEPTEMBER: 
            case DECEMBER: {
                LocalDate immDate = LocalDateIMMDateCalculator.calculate3rdWednesday(date);
                if (requestNextIMM && !date.isBefore(immDate)) {
                    date = date.plusMonths(3L);
                    break;
                }
                if (requestNextIMM || date.isAfter(immDate)) break;
                date = date.minusMonths(3L);
                break;
            }
            default: {
                if (requestNextIMM) {
                    int monthOffset = (12 - month.getValue()) % 3;
                    date = date.plusMonths(monthOffset);
                    break;
                }
                int monthOffset = month.getValue() % 3;
                date = date.minusMonths(monthOffset);
            }
        }
        return date;
    }

    private static LocalDate calculate3rdWednesday(LocalDate original) {
        return original.with(TemporalAdjusters.firstInMonth(DayOfWeek.WEDNESDAY)).plusWeeks(2L);
    }

    @Override
    public boolean isIMMDate(LocalDate date) {
        boolean same = false;
        List<LocalDate> dates = this.getIMMDates(date.minusDays(1L), date, IMMPeriod.QUARTERLY);
        if (!dates.isEmpty()) {
            same = date.equals(dates.get(0));
        }
        return same;
    }
}

