/*
 * Decompiled with CFR 0.152.
 */
package net.objectlab.kit.datecalc.jdk8;

import java.time.LocalDate;
import net.objectlab.kit.datecalc.common.BaseCalculator;
import net.objectlab.kit.datecalc.common.HolidayHandler;
import net.objectlab.kit.datecalc.common.NonWorkingDayChecker;

public class LocalDateModifiedFollowingHandler
implements HolidayHandler<LocalDate> {
    @Override
    public LocalDate moveCurrentDate(BaseCalculator<LocalDate> calculator) {
        return this.adjustDate(calculator.getCurrentBusinessDate(), 1, (NonWorkingDayChecker<LocalDate>)calculator);
    }

    @Override
    public LocalDate adjustDate(LocalDate startDate, int increment, NonWorkingDayChecker<LocalDate> checker) {
        LocalDate date = startDate;
        int month = date.getMonthValue();
        int stepToUse = increment;
        while (checker.isNonWorkingDay(date)) {
            if ((date = date.plusDays(stepToUse)).getMonthValue() == month) continue;
            date = date.plusDays(stepToUse *= -1);
        }
        return date;
    }

    @Override
    public String getType() {
        return "modifiedFollowing";
    }
}

