/*
 * Decompiled with CFR 0.152.
 */
package net.objectlab.kit.datecalc.jdk8;

import java.time.LocalDate;
import java.time.Month;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAdjusters;
import net.objectlab.kit.datecalc.common.PeriodCountBasis;
import net.objectlab.kit.datecalc.common.PeriodCountCalculator;

public class LocalDatePeriodCountCalculator
implements PeriodCountCalculator<LocalDate> {
    @Override
    public int dayDiff(LocalDate start, LocalDate end, PeriodCountBasis basis) {
        int diff;
        switch (basis) {
            case CONV_30_360: {
                diff = this.diffConv30v360(start, end);
                break;
            }
            case CONV_360E_ISDA: {
                diff = this.diff360EIsda(start, end);
                break;
            }
            case CONV_360E_ISMA: {
                diff = this.diff360EIsma(start, end);
                break;
            }
            default: {
                diff = (int)ChronoUnit.DAYS.between(start, end);
            }
        }
        return diff;
    }

    private int diff360EIsma(LocalDate start, LocalDate end) {
        int dayStart = start.getDayOfMonth();
        int dayEnd = end.getDayOfMonth();
        if (dayEnd == 31) {
            dayEnd = 30;
        }
        if (dayStart == 31) {
            dayStart = 30;
        }
        return (end.getYear() - start.getYear()) * 360 + (end.getMonthValue() - start.getMonthValue()) * 30 + dayEnd - dayStart;
    }

    private int diff360EIsda(LocalDate start, LocalDate end) {
        if (start.equals(end)) {
            return 0;
        }
        int dayStart = start.getDayOfMonth();
        int dayEnd = end.getDayOfMonth();
        if (start.getMonth().length(start.isLeapYear()) == dayStart) {
            dayStart = 30;
        }
        if (end.getMonth() != Month.FEBRUARY && end.getMonth().length(end.isLeapYear()) == dayEnd) {
            dayEnd = 30;
        }
        return (end.getYear() - start.getYear()) * 360 + (end.getMonthValue() - start.getMonthValue()) * 30 + dayEnd - dayStart;
    }

    private int diffConv30v360(LocalDate start, LocalDate end) {
        int dayStart = start.getDayOfMonth();
        int dayEnd = end.getDayOfMonth();
        if (dayEnd == 31 && dayStart >= 30) {
            dayEnd = 30;
        }
        if (dayStart == 31) {
            dayStart = 30;
        }
        return (end.getYear() - start.getYear()) * 360 + (end.getMonthValue() - start.getMonthValue()) * 30 + dayEnd - dayStart;
    }

    @Override
    public double monthDiff(LocalDate start, LocalDate end, PeriodCountBasis basis) {
        return this.yearDiff(start, end, basis) * 12.0;
    }

    @Override
    public double yearDiff(LocalDate start, LocalDate end, PeriodCountBasis basis) {
        double diff = 0.0;
        switch (basis) {
            case ACT_ACT: {
                int startYear = start.getYear();
                int endYear = end.getYear();
                if (startYear == endYear) break;
                LocalDate endOfStartYear = start.with(TemporalAdjusters.lastDayOfYear());
                LocalDate startOfEndYear = end.withDayOfYear(1);
                long diff1 = ChronoUnit.DAYS.between(start, endOfStartYear);
                long diff2 = ChronoUnit.DAYS.between(startOfEndYear, end);
                diff = ((double)diff1 + 1.0) / (double)start.lengthOfYear() + ((double)(endYear - startYear) - 1.0) + (double)diff2 / (double)end.lengthOfYear();
                break;
            }
            case CONV_30_360: 
            case CONV_360E_ISDA: 
            case CONV_360E_ISMA: 
            case ACT_360: {
                diff = (double)this.dayDiff(start, end, basis) / 360.0;
                break;
            }
            case ACT_365: {
                diff = (double)this.dayDiff(start, end, basis) / 365.0;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Sorry ACT_UST is not supported");
            }
        }
        return diff;
    }
}

