/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.nio.BufferUnderflowException;
import java.util.function.Consumer;
import java.util.function.Function;
import net.openhft.chronicle.bytes.AccessCommon;
import net.openhft.chronicle.bytes.BytesUtil;
import net.openhft.chronicle.bytes.RandomCommon;
import net.openhft.chronicle.bytes.RandomDataInput;

public interface StreamingCommon<S extends StreamingCommon<S, A, AT>, A extends AccessCommon<AT>, AT>
extends RandomCommon<S, A, AT> {
    default public long remaining() {
        return this.limit() - this.position();
    }

    public S position(long var1);

    public long position();

    public S limit(long var1);

    public S clear();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public S withLength(long length, Consumer<S> bytesConsumer) {
        if (length > this.remaining()) {
            throw new BufferUnderflowException();
        }
        long limit0 = this.limit();
        long limit = this.position() + length;
        try {
            this.limit(limit);
            bytesConsumer.accept(this);
        }
        finally {
            this.limit(limit0);
            this.position(limit);
        }
        return (S)this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public <S, R> R reply(long length, Function<S, R> bytesConsumer) {
        if (length > this.remaining()) {
            throw new BufferUnderflowException();
        }
        long limit0 = this.limit();
        long limit = this.position() + length;
        try {
            this.limit(limit);
            R r = bytesConsumer.apply(this);
            return r;
        }
        finally {
            this.limit(limit0);
            this.position(limit);
        }
    }

    public S skip(long var1);

    public S flip();

    default public String toDebugString(long maxLength) {
        return BytesUtil.toDebugString((RandomDataInput)((Object)((StreamingCommon)((Object)((RandomDataInput)((Object)this))))), maxLength);
    }

    default public String toDebugString() {
        return this.toDebugString(128L);
    }

    default public long accessPositionOffset() {
        return this.accessOffset(this.position());
    }
}

