/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes.ref;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import net.openhft.chronicle.bytes.Byteable;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.ref.StoreRef;
import net.openhft.chronicle.core.util.WeakReferenceCleaner;
import net.openhft.chronicle.core.values.BooleanValue;

public class BinaryBooleanReference
implements BooleanValue,
Byteable {
    private BytesStore bytes;
    private long offset;
    private final StoreRef ref = new StoreRef();
    private static final byte FALSE = -80;
    private static final byte TRUE = -79;

    public BinaryBooleanReference() {
        WeakReferenceCleaner.newCleaner((Object)this, this.ref::clean);
    }

    public void bytesStore(BytesStore bytes, long offset, long length) throws IllegalStateException, IllegalArgumentException, BufferOverflowException, BufferUnderflowException {
        if (length != this.maxSize()) {
            throw new IllegalArgumentException();
        }
        this.acceptNewBytesStore(bytes);
        this.offset = offset;
    }

    public BytesStore bytesStore() {
        return this.bytes;
    }

    @Override
    public long offset() {
        return this.offset;
    }

    @Override
    public long maxSize() {
        return 1L;
    }

    public boolean getValue() {
        byte b = this.bytes.readByte(this.offset);
        if (b == -80) {
            return false;
        }
        if (b == -79) {
            return true;
        }
        throw new IllegalStateException("unexpected code=" + b);
    }

    public void setValue(boolean flag) {
        this.bytes.writeByte(this.offset, flag ? (byte)-79 : -80);
    }

    private void acceptNewBytesStore(BytesStore bytes) {
        if (this.bytes != null) {
            this.bytes.release();
        }
        this.ref.b = this.bytes = bytes.bytesStore();
        this.bytes.reserve();
    }
}

