/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core;

import java.lang.ref.WeakReference;
import java.util.List;
import net.openhft.chronicle.core.io.Closeable;

public interface ReferenceCounted
extends Closeable {
    public static void releaseAll(List<WeakReference<ReferenceCounted>> refCounts) {
        for (WeakReference<ReferenceCounted> refCountRef : refCounts) {
            ReferenceCounted refCounted;
            if (refCountRef == null || (refCounted = (ReferenceCounted)refCountRef.get()) == null) continue;
            try {
                refCounted.release();
            }
            catch (IllegalStateException illegalStateException) {}
        }
    }

    public static void release(Object o) {
        if (o instanceof ReferenceCounted) {
            ReferenceCounted rc = (ReferenceCounted)o;
            try {
                rc.release();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    public void reserve() throws IllegalStateException;

    public void release() throws IllegalStateException;

    @Override
    default public void close() {
        this.release();
    }

    public long refCount();

    default public boolean tryReserve() {
        try {
            if (this.refCount() > 0L) {
                this.reserve();
                return true;
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        return false;
    }
}

