/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.io;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import sun.reflect.Reflection;

public enum IOTools {


    public static byte[] readFile(String name) throws IOException {
        int len;
        ClassLoader classLoader;
        try {
            classLoader = Reflection.getCallerClass().getClassLoader();
        }
        catch (Throwable e) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        InputStream is = classLoader.getResourceAsStream(name);
        if (is == null) {
            is = classLoader.getResourceAsStream(name + ".gz");
        }
        if (is == null) {
            try {
                is = new FileInputStream(name);
            }
            catch (FileNotFoundException e) {
                try {
                    is = new FileInputStream(name + ".gz");
                }
                catch (FileNotFoundException e1) {
                    throw e;
                }
            }
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream(Math.min(512, is.available()));
        byte[] bytes = new byte[1024];
        while ((len = is.read(bytes)) > 0) {
            out.write(bytes, 0, len);
        }
        return out.toByteArray();
    }
}

