/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.util;

import java.lang.management.ManagementFactory;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AllocationMeasure {
    private static final Logger LOG = LoggerFactory.getLogger(AllocationMeasure.class);
    private static final String GET_THREAD_ALLOCATED_BYTES = "getThreadAllocatedBytes";
    private final String[] SIGNATURE = new String[]{Long.TYPE.getName()};
    private final String threadName = Thread.currentThread().getName();
    private final Object[] PARAMS = new Object[]{Thread.currentThread().getId()};
    private MBeanServer mBeanServer;
    private ObjectName name = null;
    private AtomicLong allocated = new AtomicLong();
    private long BYTES_USED_TO_MEASURE = 336L;
    private long tid = Thread.currentThread().getId();

    public AllocationMeasure() throws IllegalStateException {
        try {
            this.name = new ObjectName("java.lang:type=Threading");
            this.mBeanServer = ManagementFactory.getPlatformMBeanServer();
        }
        catch (MalformedObjectNameException e) {
            LOG.error("", (Throwable)e);
        }
        for (int i = 0; i < 100; ++i) {
            this.markAllocations();
        }
        long callibrate = this.threadAllocatedBytes();
        this.BYTES_USED_TO_MEASURE = this.threadAllocatedBytes() - callibrate;
        this.reset();
    }

    public static void main(String[] args) throws IllegalStateException {
        String TEST = "Test";
        AllocationMeasure allocationMeasure = new AllocationMeasure();
        for (int i = 0; i < 1000; ++i) {
            allocationMeasure.reset();
            long mark1 = allocationMeasure.markAllocations();
            if (mark1 <= 0L) continue;
            System.out.println("m1:" + mark1);
        }
        allocationMeasure.printAllocations(TEST);
    }

    public void reset() throws IllegalStateException {
        if (this.tid != Thread.currentThread().getId()) {
            throw new AssertionError((Object)"AllocationMeasure must not be used over more than 1 thread.");
        }
        this.allocated.set(this.threadAllocatedBytes());
    }

    private long threadAllocatedBytes() throws IllegalStateException {
        try {
            return (Long)this.mBeanServer.invoke(this.name, GET_THREAD_ALLOCATED_BYTES, this.PARAMS, this.SIGNATURE);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public long markAllocations() throws IllegalStateException {
        if (this.tid != Thread.currentThread().getId()) {
            throw new AssertionError((Object)"AllocationMeasure must not be used over more than 1 thread.");
        }
        long mark1 = this.threadAllocatedBytes() - this.BYTES_USED_TO_MEASURE - this.allocated.get();
        this.allocated.set(this.threadAllocatedBytes());
        return mark1;
    }

    public void printAllocations(CharSequence marker) throws IllegalStateException {
        if (this.tid != Thread.currentThread().getId()) {
            throw new AssertionError((Object)"AllocationMeasure must not be used over more than 1 thread.");
        }
        long mark1 = this.threadAllocatedBytes() - this.BYTES_USED_TO_MEASURE - this.allocated.get();
        LOG.info(this.threadName + " allocated " + marker + ":" + mark1);
        this.allocated.set(this.threadAllocatedBytes());
    }
}

