/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.util;

import java.util.function.DoubleFunction;

public class Histogram {
    private final int fractionBits;
    private long totalCount;
    private long overRange;
    private int[] sampleCount;
    private long floor;

    public Histogram() {
        this(42, 4);
    }

    public Histogram(int powersOf2, int fractionBits) {
        this.fractionBits = fractionBits;
        this.sampleCount = new int[powersOf2 << fractionBits];
        this.floor = Double.doubleToRawLongBits(1.0) >> 52 - fractionBits;
    }

    public int sample(double time) {
        int bucket = (int)((Double.doubleToRawLongBits(time) >> 52 - this.fractionBits) - this.floor);
        if (bucket >= this.sampleCount.length) {
            ++this.overRange;
        } else if (bucket >= 0) {
            int n = bucket;
            this.sampleCount[n] = this.sampleCount[n] + 1;
        }
        ++this.totalCount;
        return bucket;
    }

    public double percentile(double fraction) {
        long value = (long)((double)this.totalCount * (1.0 - fraction));
        if ((value -= this.overRange) < 0L) {
            return Double.POSITIVE_INFINITY;
        }
        for (int i = this.sampleCount.length - 1; i >= 0; --i) {
            if ((value -= (long)this.sampleCount[i]) >= 0L) continue;
            long bits = ((long)i + this.floor << 1) + 1L << 51 - this.fractionBits;
            return Double.longBitsToDouble(bits);
        }
        return 1.0;
    }

    public String toMicrosFormat() {
        return this.toMicrosFormat(t -> t / 1000.0);
    }

    public String toMicrosFormat(DoubleFunction<Double> toMicros) {
        if (this.totalCount < 1000000L) {
            return "50/90 99/99.9 99.99 - worst was " + this.p(toMicros.apply(this.percentile(0.5))) + " / " + this.p(toMicros.apply(this.percentile(0.9))) + "  " + this.p(toMicros.apply(this.percentile(0.99))) + " / " + this.p(toMicros.apply(this.percentile(0.999))) + "  " + this.p(toMicros.apply(this.percentile(0.9999))) + " - " + this.p(toMicros.apply(this.percentile(1.0)));
        }
        if (this.totalCount < 10000000L) {
            return "50/90 99/99.9 99.99/99.999 - worst was " + this.p(toMicros.apply(this.percentile(0.5))) + " / " + this.p(toMicros.apply(this.percentile(0.9))) + "  " + this.p(toMicros.apply(this.percentile(0.99))) + " / " + this.p(toMicros.apply(this.percentile(0.999))) + "  " + this.p(toMicros.apply(this.percentile(0.9999))) + " / " + this.p(toMicros.apply(this.percentile(0.99999))) + " - " + this.p(toMicros.apply(this.percentile(1.0)));
        }
        return "50/90 99/99.9 99.99/99.999 99.9999/worst was " + this.p(toMicros.apply(this.percentile(0.5))) + " / " + this.p(toMicros.apply(this.percentile(0.9))) + "  " + this.p(toMicros.apply(this.percentile(0.99))) + " / " + this.p(toMicros.apply(this.percentile(0.999))) + "  " + this.p(toMicros.apply(this.percentile(0.9999))) + " / " + this.p(toMicros.apply(this.percentile(0.99999))) + "  " + this.p(toMicros.apply(this.percentile(0.999999))) + " / " + this.p(toMicros.apply(this.percentile(1.0)));
    }

    public String toLongMicrosFormat(DoubleFunction<Double> toMicros) {
        if (this.totalCount < 1000000L) {
            return "50/90 93/99 99.3/99.9 99.93/99.99 - worst was " + this.p(toMicros.apply(this.percentile(0.5))) + " / " + this.p(toMicros.apply(this.percentile(0.9))) + "  " + this.p(toMicros.apply(this.percentile(0.93))) + " / " + this.p(toMicros.apply(this.percentile(0.99))) + "  " + this.p(toMicros.apply(this.percentile(0.993))) + " / " + this.p(toMicros.apply(this.percentile(0.999))) + "  " + this.p(toMicros.apply(this.percentile(0.9993))) + " / " + this.p(toMicros.apply(this.percentile(0.9999))) + " - " + this.p(toMicros.apply(this.percentile(1.0)));
        }
        if (this.totalCount < 10000000L) {
            return "50/90 93/99 99.3/99.9 99.93/99.99 99.993/99.999 - worst was " + this.p(toMicros.apply(this.percentile(0.5))) + " / " + this.p(toMicros.apply(this.percentile(0.9))) + "  " + this.p(toMicros.apply(this.percentile(0.93))) + " / " + this.p(toMicros.apply(this.percentile(0.99))) + "  " + this.p(toMicros.apply(this.percentile(0.993))) + " / " + this.p(toMicros.apply(this.percentile(0.999))) + "  " + this.p(toMicros.apply(this.percentile(0.9993))) + " / " + this.p(toMicros.apply(this.percentile(0.9999))) + "  " + this.p(toMicros.apply(this.percentile(0.99993))) + " / " + this.p(toMicros.apply(this.percentile(0.99999))) + " - " + this.p(toMicros.apply(this.percentile(1.0)));
        }
        return "50/90 93/99 99.3/99.9 99.93/99.99 99.993/99.999 99.9993/99.9999 - worst was " + this.p(toMicros.apply(this.percentile(0.5))) + " / " + this.p(toMicros.apply(this.percentile(0.9))) + "  " + this.p(toMicros.apply(this.percentile(0.93))) + " / " + this.p(toMicros.apply(this.percentile(0.99))) + "  " + this.p(toMicros.apply(this.percentile(0.993))) + " / " + this.p(toMicros.apply(this.percentile(0.999))) + "  " + this.p(toMicros.apply(this.percentile(0.9993))) + " / " + this.p(toMicros.apply(this.percentile(0.9999))) + "  " + this.p(toMicros.apply(this.percentile(0.99993))) + " / " + this.p(toMicros.apply(this.percentile(0.99999))) + "  " + this.p(toMicros.apply(this.percentile(0.999993))) + " / " + this.p(toMicros.apply(this.percentile(0.999999))) + " - " + this.p(toMicros.apply(this.percentile(1.0)));
    }

    private String p(double v) {
        return v < 0.1 ? String.format("%.3f", v) : (v < 1.0 ? String.format("%.2f", v) : (v < 10.0 ? String.format("%.1f", v) : (v < 1000.0 ? Long.toString(Math.round(v)) : String.format("%,d", Math.round(v / 10.0) * 10L))));
    }

    public long totalCount() {
        return this.totalCount;
    }
}

